/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.config.packets;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.FDRegistries;
import com.finderfeed.fdlib.systems.config.JsonConfig;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:trigger_clientside_config_reload")
public class TriggerClientsideConfigReloadPacket
extends FDPacket {
    private boolean sendMessages;

    public TriggerClientsideConfigReloadPacket(boolean sendMessages) {
        this.sendMessages = sendMessages;
    }

    public TriggerClientsideConfigReloadPacket(FriendlyByteBuf buf) {
        this.sendMessages = buf.readBoolean();
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.sendMessages);
    }

    @Override
    public void clientAction(IPayloadContext context) {
        Player player = FDClientHelpers.getClientPlayer();
        for (Map.Entry v : FDRegistries.CONFIGS.entrySet()) {
            JsonConfig config = (JsonConfig)v.getValue();
            if (!config.isClientside()) continue;
            if (player != null && this.sendMessages) {
                player.sendSystemMessage((Component)Component.literal((String)("Reloading client config: " + String.valueOf(config.getName()))).withStyle(ChatFormatting.GREEN));
            }
            config.loadFromDisk();
            if (player == null || !this.sendMessages) continue;
            player.sendSystemMessage((Component)Component.literal((String)"Reload complete").withStyle(ChatFormatting.GREEN));
        }
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }
}

