/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.data_structures.ObjectHolder;
import com.finderfeed.fdlib.init.FDClientModEvents;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.ClientCameraEntity;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneExecutor;
import com.finderfeed.fdlib.systems.hud.FDHuds;
import com.finderfeed.fdlib.systems.screen.screen_particles.ScreenParticlesRenderEvent;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(modid="fdlib", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class CutsceneCameraHandler {
    private static ClientCameraEntity clientCameraEntity;
    private static CutsceneExecutor cutsceneExecutor;

    @SubscribeEvent
    private static void onLogoff(ClientPlayerNetworkEvent.LoggingOut out) {
        clientCameraEntity = null;
        cutsceneExecutor = null;
    }

    @SubscribeEvent
    public static void renderScreenParticlesEvent(ScreenParticlesRenderEvent.Gui event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderScreenParticlesEvent2(ScreenParticlesRenderEvent.Screen event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tickEvent(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            CutsceneCameraHandler.stopCutscene();
            return;
        }
        boolean wasStoppedByPlayer = false;
        while (FDClientModEvents.END_CUTSCENE.consumeClick()) {
            wasStoppedByPlayer = true;
        }
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        CutsceneCameraHandler.nullifyInput(player);
        if (cutsceneExecutor.getData().getStopMode() == CutsceneData.StopMode.PLAYER && wasStoppedByPlayer) {
            CutsceneCameraHandler.stopCutscene();
            return;
        }
        if (Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON) {
            Minecraft.getInstance().options.setCameraType(CameraType.FIRST_PERSON);
        }
        CutsceneCameraHandler.ensurePlayerIsACamera();
        cutsceneExecutor.tick(clientCameraEntity);
        if (cutsceneExecutor.hasEnded() && cutsceneExecutor.getData().getStopMode() == CutsceneData.StopMode.AUTOMATIC) {
            CutsceneCameraHandler.stopCutscene();
        }
    }

    public static void nullifyInput(LocalPlayer player) {
        Input input = player.input;
        input.leftImpulse = 0.0f;
        input.forwardImpulse = 0.0f;
        input.up = false;
        input.down = false;
        input.left = false;
        input.right = false;
        input.jumping = false;
        input.shiftKeyDown = false;
    }

    @SubscribeEvent
    public static void renderHighlightEvent(RenderHighlightEvent.Block event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGuiLayers(RenderGuiLayerEvent.Pre event) {
        if (CutsceneCameraHandler.isCutsceneActive() && event.getLayer() != FDHuds.SCREEN_EFFECT_OVERLAY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelPlayerMouseUsage(InputEvent.InteractionKeyMappingTriggered event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void cameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        ObjectHolder<Float> yaw = new ObjectHolder<Float>(Float.valueOf(event.getYaw()));
        ObjectHolder<Float> pitch = new ObjectHolder<Float>(Float.valueOf(event.getPitch()));
        ObjectHolder<Float> roll = new ObjectHolder<Float>(Float.valueOf(event.getRoll()));
        cutsceneExecutor.setCameraRotation((float)event.getPartialTick(), yaw, pitch, roll);
        event.setPitch(pitch.getValue().floatValue());
        event.setYaw(yaw.getValue().floatValue());
        event.setRoll(roll.getValue().floatValue());
    }

    private static void ensurePlayerIsACamera() {
        Entity camera;
        if (cutsceneExecutor != null && clientCameraEntity != null && !((camera = Minecraft.getInstance().cameraEntity) instanceof ClientCameraEntity)) {
            Minecraft.getInstance().setCameraEntity((Entity)clientCameraEntity);
        }
    }

    public static void startCutscene(CutsceneData data) {
        Level level = FDClientHelpers.getClientLevel();
        Entity currentCamera = Minecraft.getInstance().cameraEntity;
        if (currentCamera instanceof ClientCameraEntity) {
            return;
        }
        ClientCameraEntity camera = new ClientCameraEntity(level);
        CameraPos pos = data.getCameraPositions().get(0);
        Vec3 p = pos.getPos();
        camera.setPos(p);
        camera.xo = p.x;
        camera.yo = p.y;
        camera.zo = p.z;
        Minecraft.getInstance().setCameraEntity((Entity)camera);
        clientCameraEntity = camera;
        cutsceneExecutor = new CutsceneExecutor(data);
    }

    public static void moveCamera(CutsceneData cutsceneData) {
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        cutsceneData = new CutsceneData(cutsceneData);
        Vec3 pos = cutsceneExecutor.getCameraPos();
        ObjectHolder<Float> yaw = new ObjectHolder<Float>(Float.valueOf(0.0f));
        ObjectHolder<Float> pitch = new ObjectHolder<Float>(Float.valueOf(0.0f));
        ObjectHolder<Float> roll = new ObjectHolder<Float>(Float.valueOf(0.0f));
        cutsceneExecutor.setCameraRotation(0.0f, yaw, pitch, roll);
        cutsceneData.addCameraPos(0, new CameraPos(pos, yaw.getValue().floatValue(), pitch.getValue().floatValue(), roll.getValue().floatValue()));
        cutsceneExecutor = new CutsceneExecutor(cutsceneData);
    }

    public static void stopCutscene() {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            clientCameraEntity = null;
            cutsceneExecutor = null;
            MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
            mouseHandler.accumulatedDX = 0.0;
            mouseHandler.accumulatedDY = 0.0;
            Minecraft.getInstance().setCameraEntity((Entity)Minecraft.getInstance().player);
        }
    }

    public static CutsceneExecutor getCutsceneExecutor() {
        return cutsceneExecutor;
    }

    public static boolean isCutsceneActive() {
        return clientCameraEntity != null && cutsceneExecutor != null;
    }
}

