/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes;

import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CurveType;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class CutsceneData
implements AutoSerializable {
    private List<CameraPos> cameraPositions = new ArrayList<CameraPos>();
    @SerializableField
    private int cutsceneTime = 20;
    @SerializableField
    private CurveType moveType = CurveType.CATMULLROM;
    @SerializableField
    private EasingType timeEasing = EasingType.LINEAR;
    @SerializableField
    private EasingType lookEasing = EasingType.LINEAR;
    @SerializableField
    private StopMode stopMode = StopMode.AUTOMATIC;

    public CutsceneData() {
    }

    public CutsceneData(CutsceneData cutsceneData) {
        this.cutsceneTime = cutsceneData.cutsceneTime;
        this.moveType = cutsceneData.moveType;
        this.timeEasing = cutsceneData.timeEasing;
        this.stopMode = cutsceneData.stopMode;
        this.cameraPositions = new ArrayList<CameraPos>(cutsceneData.cameraPositions);
    }

    public CutsceneData stopMode(StopMode stopMode) {
        this.stopMode = stopMode;
        return this;
    }

    public CutsceneData timeEasing(EasingType type) {
        this.timeEasing = type;
        return this;
    }

    public CutsceneData lookEasing(EasingType type) {
        this.lookEasing = type;
        return this;
    }

    public CutsceneData addCameraPos(CameraPos pos) {
        this.cameraPositions.add(pos);
        return this;
    }

    public CutsceneData addCameraPos(int index, CameraPos pos) {
        this.cameraPositions.add(index, pos);
        return this;
    }

    public CutsceneData time(int timeInTicks) {
        this.cutsceneTime = timeInTicks;
        return this;
    }

    public CutsceneData moveCurveType(CurveType type) {
        this.moveType = type;
        return this;
    }

    public CurveType getMoveType() {
        return this.moveType;
    }

    public int getCutsceneTime() {
        return this.cutsceneTime;
    }

    public List<CameraPos> getCameraPositions() {
        return this.cameraPositions;
    }

    public EasingType getTimeEasing() {
        return this.timeEasing;
    }

    public EasingType getLookEasing() {
        return this.lookEasing;
    }

    public StopMode getStopMode() {
        return this.stopMode;
    }

    public static CutsceneData create() {
        return new CutsceneData();
    }

    @Override
    public void autoLoad(CompoundTag tag) {
        AutoSerializable.super.autoLoad(tag);
        int size = tag.getInt("cameraPosListLength");
        for (int i = 0; i < size; ++i) {
            CameraPos pos = new CameraPos();
            pos.autoLoad("pos_" + i, tag);
            this.cameraPositions.add(pos);
        }
    }

    @Override
    public void autoSave(CompoundTag tag) {
        AutoSerializable.super.autoSave(tag);
        tag.putInt("cameraPosListLength", this.cameraPositions.size());
        for (int i = 0; i < this.cameraPositions.size(); ++i) {
            CameraPos pos = this.cameraPositions.get(i);
            pos.autoSave("pos_" + i, tag);
        }
    }

    public static enum StopMode {
        AUTOMATIC,
        PLAYER,
        UNSTOPPABLE;

    }
}

