/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.entity.action_chain;

import com.finderfeed.fdlib.systems.entity.action_chain.Attack;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackAction;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackDefinition;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackExecutor;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackInstance;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackOptions;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class AttackChain {
    private HashMap<String, AttackExecutor> registeredAttackExecutors = new HashMap();
    private List<Pair<Integer, AttackOptions>> attackOptions = new ArrayList<Pair<Integer, AttackOptions>>();
    private Queue<String> chain = new ArrayDeque<String>();
    private AttackInstance currentAttack = null;
    private Function<String, AttackAction> attackListener = inst -> AttackAction.PROCEED;
    private RandomSource source;

    public AttackChain(RandomSource source) {
        this.source = source;
    }

    public AttackChain registerInClassAttacks(Class<? extends Entity> entityClass) {
        for (Method method : entityClass.getDeclaredMethods()) {
            Attack attack = method.getAnnotation(Attack.class);
            if (attack == null) continue;
            method.setAccessible(true);
            this.registerAttack(attack.value(), instance -> {
                try {
                    return (Boolean)method.invoke((Object)instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this;
    }

    public AttackChain attackListener(Function<String, AttackAction> listener) {
        this.attackListener = listener;
        return this;
    }

    public AttackChain registerAttack(String name, AttackExecutor executor) {
        this.registeredAttackExecutors.put(name, executor);
        return this;
    }

    public AttackChain addAttack(int priority, AttackOptions options) {
        this.attackOptions.add((Pair<Integer, AttackOptions>)new Pair((Object)priority, (Object)options));
        this.attackOptions.sort(Comparator.comparingInt(Pair::getFirst));
        return this;
    }

    public AttackChain addAttack(int priority, String attack) {
        return this.addAttack(priority, AttackOptions.builder().addAttack(attack).build());
    }

    public void tick() {
        if (this.chain.isEmpty() && this.currentAttack == null) {
            this.buildQueue();
        } else if (this.currentAttack != null) {
            int previousStage = this.currentAttack.stage;
            if (this.currentAttack.attack.execute(this.currentAttack)) {
                this.currentAttack = null;
                this.pollAndExecuteAttack();
            } else if (this.currentAttack.stage == previousStage) {
                ++this.currentAttack.tick;
            }
        } else {
            this.pollAndExecuteAttack();
        }
    }

    private void pollAndExecuteAttack() {
        String executorName;
        AttackAction attackAction;
        while (this.currentAttack == null && !this.chain.isEmpty() && (attackAction = this.attackListener.apply(executorName = this.chain.peek())) != AttackAction.WAIT) {
            if (attackAction != AttackAction.PROCEED) {
                if (attackAction != AttackAction.SKIP) break;
                this.chain.poll();
                continue;
            }
            this.chain.poll();
            AttackExecutor executor = this.registeredAttackExecutors.get(executorName);
            if (executor == null) {
                throw new RuntimeException("Attack not registered: " + executorName);
            }
            this.currentAttack = new AttackInstance(executorName, executor);
            if (this.currentAttack.attack.execute(this.currentAttack)) {
                this.currentAttack = null;
                continue;
            }
            if (this.currentAttack.stage != 0) continue;
            ++this.currentAttack.tick;
        }
    }

    public void buildQueue() {
        this.chain.clear();
        ArrayList<AttackOptions> samePriority = new ArrayList<AttackOptions>();
        int currentValue = (Integer)this.attackOptions.get(0).getFirst();
        for (Pair<Integer, AttackOptions> pair : this.attackOptions) {
            if ((Integer)pair.getFirst() == currentValue) {
                samePriority.add((AttackOptions)pair.getSecond());
                continue;
            }
            this.addSamePriorityOptionsToQueue(samePriority);
            samePriority.add((AttackOptions)pair.getSecond());
            currentValue = (Integer)pair.getFirst();
        }
        this.addSamePriorityOptionsToQueue(samePriority);
    }

    private void addSamePriorityOptionsToQueue(List<AttackOptions> samePriority) {
        while (!samePriority.isEmpty()) {
            int rndid = this.source.nextInt(samePriority.size());
            AttackOptions options = samePriority.get(rndid);
            this.addOptionsToQueue(options);
            samePriority.remove(rndid);
        }
    }

    private void addOptionsToQueue(AttackOptions options) {
        AttackOptions pre = options.getPreAttackOptions();
        if (pre != null) {
            this.addOptionsToQueue(pre);
        }
        for (AttackOptions next = options; next != null; next = next.getNextAttackOptions()) {
            AttackDefinition definition = next.getAttack(this.source);
            if (definition.getExecutorName() != null) {
                this.chain.offer(definition.getExecutorName());
                continue;
            }
            this.addOptionsToQueue(definition.getOptions());
        }
    }

    public void reset() {
        this.currentAttack = null;
        this.chain.clear();
    }

    public AttackInstance getCurrentAttack() {
        return this.currentAttack;
    }

    public void load(CompoundTag tag) {
        int index = 0;
        while (tag.contains("attack_" + index)) {
            this.chain.offer(tag.getString("attack_" + index));
            ++index;
        }
        if (tag.contains("currentAttack")) {
            String name = tag.getString("currentAttack");
            int tick = tag.getInt("currentAttackTick");
            int stage = tag.getInt("currentAttackStage");
            AttackExecutor executor = this.registeredAttackExecutors.get(name);
            AttackInstance instance = new AttackInstance(name, executor);
            instance.tick = tick;
            instance.stage = stage;
            this.currentAttack = instance;
        }
    }

    public void save(CompoundTag tag) {
        int index = 0;
        for (String s : this.chain) {
            tag.putString("attack_" + index++, s);
        }
        if (this.currentAttack != null) {
            tag.putString("currentAttack", this.currentAttack.name);
            tag.putInt("currentAttackTick", this.currentAttack.tick);
            tag.putInt("currentAttackStage", this.currentAttack.stage);
        }
    }
}

