/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.entity.action_chain;

import com.finderfeed.fdlib.systems.entity.action_chain.AttackDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import org.jetbrains.annotations.NotNull;

public class AttackOptions
implements Iterable<AttackDefinition> {
    private WeightedRandomList<AttackDefinition> weightedRandomList;
    private AttackOptions preAttackOptions = null;
    private AttackOptions nextAttackOptions = null;

    public AttackOptions(List<AttackDefinition> attackDefinitions, AttackOptions pre, AttackOptions next) {
        this.nextAttackOptions = next;
        this.preAttackOptions = pre;
        this.weightedRandomList = WeightedRandomList.create(attackDefinitions);
    }

    public AttackDefinition getAttack(RandomSource source) {
        return (AttackDefinition)this.weightedRandomList.getRandom(source).get();
    }

    public AttackOptions getNextAttackOptions() {
        return this.nextAttackOptions;
    }

    public AttackOptions getPreAttackOptions() {
        return this.preAttackOptions;
    }

    @Override
    @NotNull
    public Iterator<AttackDefinition> iterator() {
        return this.weightedRandomList.unwrap().iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<AttackDefinition> attackDefinitions = new ArrayList<AttackDefinition>();
        private AttackOptions preAttackOptions = null;
        private AttackOptions nextAttackOptions = null;

        public Builder addAttack(int weight, String executorName) {
            this.attackDefinitions.add(new AttackDefinition(executorName, weight));
            return this;
        }

        public Builder addAttack(String executorName) {
            return this.addAttack(1, executorName);
        }

        public Builder addAttack(int weight, AttackOptions options) {
            this.attackDefinitions.add(new AttackDefinition(options, weight));
            return this;
        }

        public Builder addAttack(AttackOptions options) {
            return this.addAttack(1, options);
        }

        public Builder setNextAttack(AttackOptions options) {
            this.nextAttackOptions = options;
            return this;
        }

        public Builder setNextAttack(String executorName) {
            return this.setNextAttack(AttackOptions.builder().addAttack(executorName).build());
        }

        public Builder setPreAttack(AttackOptions options) {
            this.preAttackOptions = options;
            return this;
        }

        public Builder setPreAttack(String executorName) {
            return this.setPreAttack(AttackOptions.builder().addAttack(executorName).build());
        }

        public AttackOptions build() {
            return new AttackOptions(this.attackDefinitions, this.preAttackOptions, this.nextAttackOptions);
        }
    }
}

