/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle.particle_emitter;

import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessorType;
import com.finderfeed.fdlib.systems.particle.particle_emitter.FDEmitterProcessorTypes;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitter;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public interface EmitterProcessor<T extends EmitterProcessor<T>> {
    public static final StreamCodec<FriendlyByteBuf, EmitterProcessor<?>> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, EmitterProcessor<?>>(){

        public void encode(FriendlyByteBuf buf, EmitterProcessor<?> emitter) {
            buf.writeResourceLocation(emitter.type().id());
            EmitterProcessor.hackyEncode(buf, emitter);
        }

        public EmitterProcessor<?> decode(FriendlyByteBuf buf) {
            ResourceLocation location = buf.readResourceLocation();
            EmitterProcessorType<?> type = FDEmitterProcessorTypes.get(location);
            if (type == null) {
                throw new RuntimeException("Emitter processor type unknown: " + String.valueOf(location));
            }
            EmitterProcessor processor = (EmitterProcessor)type.codec().decode((Object)buf);
            return processor;
        }
    };

    public void initEmitter(ParticleEmitter var1);

    public void tickEmitter(ParticleEmitter var1);

    public void tickParticle(Particle var1);

    public void initParticle(Particle var1);

    public EmitterProcessorType<T> type();

    public static <T extends EmitterProcessor<T>> void hackyEncode(FriendlyByteBuf buf, EmitterProcessor<T> emitterProcessor) {
        emitterProcessor.type().codec().encode((Object)buf, emitterProcessor);
    }
}

