/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.ClientMixinHandler;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.shake.DefaultShake;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:default_shake")
public class DefaultShakePacket
extends FDPacket {
    private FDShakeData data;

    public DefaultShakePacket(FDShakeData shakeData) {
        this.data = shakeData;
    }

    public DefaultShakePacket(FriendlyByteBuf buf) {
        this.data = (FDShakeData)FDShakeData.STREAM_CODEC.decode((Object)buf);
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        FDShakeData.STREAM_CODEC.encode((Object)buf, (Object)this.data);
    }

    @Override
    public void clientAction(IPayloadContext context) {
        ClientMixinHandler.addShake(new DefaultShake(this.data));
    }

    @Override
    public void serverAction(IPayloadContext context) {
    }

    public static void send(ServerLevel level, Vec3 pos, double radius, FDShakeData data) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)new DefaultShakePacket(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

