/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.math;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.Mth;

public class ComplexEasingFunction
implements Function<Float, Float> {
    private List<EasingArea> areas = new ArrayList<EasingArea>();
    private float length = 0.0f;

    @Override
    public float apply(float value) {
        return this.apply(Float.valueOf(value)).floatValue();
    }

    @Override
    public Float apply(Float value) {
        float v;
        float len;
        if (this.length == 0.0f || this.areas.isEmpty()) {
            return value;
        }
        value = Float.valueOf(Mth.clamp((float)value.floatValue(), (float)0.0f, (float)this.length));
        EasingArea lastArea = this.areas.getFirst();
        float accumulatedLength = 0.0f;
        int idx = 1;
        while (!((len = accumulatedLength + lastArea.length) > value.floatValue()) && idx < this.areas.size()) {
            accumulatedLength = len;
            lastArea = this.areas.get(idx++);
        }
        float localLength = value.floatValue() - accumulatedLength;
        Function<Float, Float> function = lastArea.easingFunction;
        if (function instanceof ComplexEasingFunction) {
            ComplexEasingFunction complexEasingFunction = (ComplexEasingFunction)function;
            v = lastArea.easingFunction.apply(Float.valueOf(localLength)).floatValue();
        } else {
            float localPercent = localLength / lastArea.length();
            v = lastArea.easingFunction.apply(Float.valueOf(localPercent)).floatValue();
        }
        return Float.valueOf(v);
    }

    public void addEasingArea(float length, Function<Float, Float> easing) {
        this.length += length;
        this.areas.add(new EasingArea(length, easing));
    }

    public float getLength() {
        return this.length;
    }

    public static Builder builder() {
        return new Builder();
    }

    private record EasingArea(float length, Function<Float, Float> easingFunction) {
    }

    public static class Builder {
        private ComplexEasingFunction easingFunction = new ComplexEasingFunction();

        public Builder addArea(float areaLength, Function<Float, Float> easing) {
            this.easingFunction.addEasingArea(areaLength, easing);
            return this;
        }

        public ComplexEasingFunction build() {
            return this.easingFunction;
        }
    }
}

