/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.math;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FDMathUtil {
    public static final float FPI = (float)Math.PI;

    public static Vector3f vec3ToVector3f(Vec3 v) {
        return new Vector3f((float)v.x, (float)v.y, (float)v.z);
    }

    public static Vec3 vector3fToVec3(Vector3f v) {
        return new Vec3((double)v.x, (double)v.y, (double)v.z);
    }

    public static float lerp(float v1, float v2, float p) {
        return v1 + (v2 - v1) * p;
    }

    public static double lerp(double v1, double v2, double p) {
        return v1 + (v2 - v1) * p;
    }

    public static Vector3f vectorBetweenVectors(Vector3f v1, Vector3f v2) {
        return v1.add((Vector3fc)v2, new Vector3f()).normalize();
    }

    public static List<Vector3f> scalePointsInDirection(List<Vector2f> basePoints, Vector2f direction, float scale) {
        float angle = (float)Math.atan2(direction.x, direction.y);
        Matrix4f scale1 = new Matrix4f().scale(1.0f, scale, 1.0f);
        List<Vector3f> list = basePoints.stream().map(vec2 -> {
            Vector3f v = new Vector3f(vec2.x, vec2.y, 0.0f);
            v.rotateZ(angle);
            scale1.transformPosition(v);
            v.rotateZ(-angle);
            return v;
        }).toList();
        return list;
    }

    public static float yRotFromVector(Vec3 v) {
        if (v.x == 0.0 && v.z == 0.0) {
            return 0.0f;
        }
        float value = -((float)Math.atan2(v.x, v.z));
        return (float)Math.toDegrees(value);
    }

    public static float xRotFromVector(Vec3 v) {
        Vec3 g = new Vec3(v.x, 0.0, v.z);
        float value = -((float)Math.atan2(v.y, g.length()));
        return (float)Math.toDegrees(value);
    }

    public static float convertMCYRotationToNormal(float rot) {
        float d = rot % 360.0f;
        if (rot > 0.0f) {
            if (d > 180.0f) {
                return -180.0f + (d - 180.0f);
            }
            return d;
        }
        if (d < -180.0f) {
            return 180.0f - (-180.0f - d);
        }
        return d;
    }

    public static float lerpAround(float v1, float v2, float min, float max, float p) {
        float v2tomax;
        float v1tomin;
        float d2;
        float d1;
        if (v2 < v1) {
            float v = v2;
            v2 = v1;
            v1 = v;
            p = 1.0f - p;
        }
        if ((d1 = v2 - v1) < (d2 = (v1tomin = v1 - min) + (v2tomax = max - v2))) {
            return FDMathUtil.lerp(v1, v2, p);
        }
        float d = d2 * p;
        if (d < v1tomin) {
            return v1 - d;
        }
        float remain = d - v1tomin;
        return max - remain;
    }

    public static Vec3 projectVectorOnVector(Vec3 v, Vec3 on) {
        double dot = v.dot(on);
        double v2 = on.dot(on);
        double md = dot / v2;
        return on.multiply(md, md, md);
    }

    public static Vec3 projectVectorOntoPlane(Vec3 v, Vec3 normal) {
        Vec3 proj = FDMathUtil.projectVectorOnVector(v, normal);
        return v.subtract(proj);
    }

    public static double angleBetweenVectors(Vec3 v1, Vec3 v2) {
        return Math.acos(v1.dot(v2) / (v1.length() * v2.length()));
    }

    public static BlockPos vec3ToBlockPos(Vec3 v) {
        return new BlockPos((int)Math.floor(v.x), (int)Math.floor(v.y), (int)Math.floor(v.z));
    }

    public static Vec3 getNormalVectorFromLineToPoint(Vec3 begin, Vec3 end, Vec3 point) {
        Vec3 between = end.subtract(begin);
        Vec3 topr = point.subtract(begin);
        double d = topr.dot(between);
        double w = between.length();
        w *= w;
        double mod = d / w;
        return point.subtract(begin.add(between.multiply(mod, mod, mod)));
    }

    public static Vector3f interpolateVectors(Vector3f v1, Vector3f v2, float p) {
        return new Vector3f(FDMathUtil.lerp(v1.x, v2.x, p), FDMathUtil.lerp(v1.y, v2.y, p), FDMathUtil.lerp(v1.z, v2.z, p));
    }

    public static Vec3 interpolateVectors(Vec3 v1, Vec3 v2, float p) {
        return new Vec3(FDMathUtil.lerp(v1.x, v2.x, (double)p), FDMathUtil.lerp(v1.y, v2.y, (double)p), FDMathUtil.lerp(v1.z, v2.z, (double)p));
    }

    public static Vec3 catmullRom(Vec3[] points, float p) {
        if (p < 0.0f) {
            return points[0];
        }
        if (p >= 1.0f) {
            return points[points.length - 1];
        }
        float glP = p * (float)(points.length - 1);
        int id1 = (int)glP;
        float lp = glP - (float)id1;
        Vec3 prev = id1 > 0 ? points[id1] : null;
        Vec3 cur = points[id1];
        Vec3 next = points[id1 + 1];
        Vec3 next2 = id1 < points.length - 2 ? points[id1 + 2] : null;
        return FDMathUtil.catmullrom(prev, cur, next, next2, lp);
    }

    public static Vec3 linear(List<Vec3> points, float p) {
        if (p < 0.0f) {
            return points.getFirst();
        }
        if (p >= 1.0f) {
            return points.getLast();
        }
        float glP = p * (float)(points.size() - 1);
        int id1 = (int)glP;
        float lp = glP - (float)id1;
        Vec3 cur = points.get(id1);
        Vec3 next = points.get(id1 + 1);
        return FDMathUtil.interpolateVectors(cur, next, lp);
    }

    public static Vec3 catmullRom(List<Vec3> points, float p) {
        if (p < 0.0f) {
            return points.getFirst();
        }
        if (p >= 1.0f) {
            return points.getLast();
        }
        float glP = p * (float)(points.size() - 1);
        int id1 = (int)glP;
        float lp = glP - (float)id1;
        Vec3 prev = id1 > 0 ? points.get(id1) : null;
        Vec3 cur = points.get(id1);
        Vec3 next = points.get(id1 + 1);
        Vec3 next2 = id1 < points.size() - 2 ? points.get(id1 + 2) : null;
        return FDMathUtil.catmullrom(prev, cur, next, next2, lp);
    }

    public static float catmullrom(Float previous, Float current, Float next, Float next2, float p) {
        if (next == null) {
            return current.floatValue();
        }
        if (previous == null) {
            previous = Float.valueOf(current.floatValue() + (current.floatValue() - next.floatValue()));
        }
        if (next2 == null) {
            next2 = Float.valueOf(next.floatValue() + (next.floatValue() - current.floatValue()));
        }
        float xvc = (next.floatValue() - previous.floatValue()) / 6.0f;
        float xvn = (current.floatValue() - next2.floatValue()) / 6.0f;
        return FDMathUtil.bernstein(current.floatValue(), current.floatValue() + xvc, next.floatValue() + xvn, next.floatValue(), p);
    }

    public static double catmullrom(Double previous, Double current, Double next, Double next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current + (current - next);
        }
        if (next2 == null) {
            next2 = next + (next - current);
        }
        double xvc = (next - previous) / 6.0;
        double xvn = (current - next2) / 6.0;
        return FDMathUtil.bernstein(current, current + xvc, next + xvn, next, (double)p);
    }

    public static Vector3f catmullrom(Vector3f previous, Vector3f current, Vector3f next, Vector3f next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.add((Vector3fc)current.sub((Vector3fc)next, new Vector3f()), new Vector3f());
        }
        if (next2 == null) {
            next2 = next.add((Vector3fc)next.sub((Vector3fc)current, new Vector3f()), new Vector3f());
        }
        return new Vector3f(FDMathUtil.catmullrom(Float.valueOf(previous.x), Float.valueOf(current.x), Float.valueOf(next.x), Float.valueOf(next2.x), p), FDMathUtil.catmullrom(Float.valueOf(previous.y), Float.valueOf(current.y), Float.valueOf(next.y), Float.valueOf(next2.y), p), FDMathUtil.catmullrom(Float.valueOf(previous.z), Float.valueOf(current.z), Float.valueOf(next.z), Float.valueOf(next2.z), p));
    }

    public static Vec3 catmullrom(Vec3 previous, Vec3 current, Vec3 next, Vec3 next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.add(current.subtract(next));
        }
        if (next2 == null) {
            next2 = next.add(next.subtract(current));
        }
        return new Vec3(FDMathUtil.catmullrom(previous.x, current.x, next.x, next2.x, p), FDMathUtil.catmullrom(previous.y, current.y, next.y, next2.y, p), FDMathUtil.catmullrom(previous.z, current.z, next.z, next2.z, p));
    }

    private static float bernstein(float x1, float x2, float x3, float x4, float t) {
        float t3 = (float)Math.pow(t, 3.0);
        float t2 = (float)Math.pow(t, 2.0);
        return x1 * (-t3 + 3.0f * t2 - 3.0f * t + 1.0f) + x2 * (3.0f * t3 - 6.0f * t2 + 3.0f * t) + x3 * (-3.0f * t3 + 3.0f * t2) + x4 * t3;
    }

    private static double bernstein(double x1, double x2, double x3, double x4, double t) {
        double t3 = Math.pow(t, 3.0);
        double t2 = Math.pow(t, 2.0);
        return x1 * (-t3 + 3.0 * t2 - 3.0 * t + 1.0) + x2 * (3.0 * t3 - 6.0 * t2 + 3.0 * t) + x3 * (-3.0 * t3 + 3.0 * t2) + x4 * t3;
    }

    public static float normalDistribution(float x, float m, float o) {
        float fc = 1.0f / org.joml.Math.sqrt((float)(o * o * (float)Math.PI * 2.0f));
        float st = (float)Math.pow(x - m, 2.0) / (2.0f * o * o);
        float mt = (float)Math.exp(-st);
        return fc * mt;
    }
}

