/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.cutscenes;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.data_structures.ObjectHolder;
import com.finderfeed.fdlib.init.FDClientModEvents;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.ClientCameraEntity;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneExecutor;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneScreenEffectData;
import com.finderfeed.fdlib.systems.hud.FDHuds;
import com.finderfeed.fdlib.systems.screen.screen_particles.ScreenParticlesRenderEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fdlib", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CutsceneCameraHandler {
    private static ClientCameraEntity clientCameraEntity;
    private static CutsceneExecutor cutsceneExecutor;

    @SubscribeEvent
    public static void onLogoff(ClientPlayerNetworkEvent.LoggingOut out) {
        clientCameraEntity = null;
        cutsceneExecutor = null;
    }

    @SubscribeEvent
    public static void renderScreenParticlesEvent(ScreenParticlesRenderEvent.Gui event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderScreenParticlesEvent2(ScreenParticlesRenderEvent.Screen event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (player == null) {
            CutsceneCameraHandler.stopCutscene();
            return;
        }
        boolean wasStoppedByPlayer = false;
        while (FDClientModEvents.END_CUTSCENE.m_90859_()) {
            wasStoppedByPlayer = true;
        }
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        CutsceneCameraHandler.nullifyInput(player);
        if (cutsceneExecutor.getData().getStopMode() == CutsceneData.StopMode.PLAYER && wasStoppedByPlayer) {
            CutsceneCameraHandler.stopCutscene();
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            Minecraft.m_91087_().f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        CutsceneCameraHandler.ensurePlayerIsACamera();
        cutsceneExecutor.tick(clientCameraEntity);
        if (cutsceneExecutor.hasEnded()) {
            CutsceneData nextCutscene = cutsceneExecutor.getData().getNextCutscene();
            if (nextCutscene != null) {
                CutsceneCameraHandler.startCutscene(nextCutscene);
            } else if (cutsceneExecutor.getData().getStopMode() == CutsceneData.StopMode.AUTOMATIC) {
                CutsceneCameraHandler.stopCutscene();
            }
        }
    }

    public static void nullifyInput(LocalPlayer player) {
        Input input = player.f_108618_;
        input.f_108566_ = 0.0f;
        input.f_108567_ = 0.0f;
        input.f_108568_ = false;
        input.f_108569_ = false;
        input.f_108570_ = false;
        input.f_108571_ = false;
        input.f_108572_ = false;
        input.f_108573_ = false;
    }

    @SubscribeEvent
    public static void renderHighlightEvent(RenderHighlightEvent.Block event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGuiLayers(RenderGuiOverlayEvent.Pre event) {
        if (CutsceneCameraHandler.isCutsceneActive() && event.getOverlay().overlay() != FDHuds.SCREEN_EFFECT_OVERLAY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelPlayerMouseUsage(InputEvent.InteractionKeyMappingTriggered event) {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void cameraAngles(ViewportEvent.ComputeCameraAngles event) {
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        ObjectHolder<Float> yaw = new ObjectHolder<Float>(Float.valueOf(event.getYaw()));
        ObjectHolder<Float> pitch = new ObjectHolder<Float>(Float.valueOf(event.getPitch()));
        ObjectHolder<Float> roll = new ObjectHolder<Float>(Float.valueOf(event.getRoll()));
        cutsceneExecutor.setCameraRotation((float)event.getPartialTick(), yaw, pitch, roll);
        Camera camera = event.getCamera();
        camera.m_90572_(yaw.getValue().floatValue(), pitch.getValue().floatValue());
        event.setPitch(pitch.getValue().floatValue());
        event.setYaw(yaw.getValue().floatValue());
        event.setRoll(roll.getValue().floatValue());
    }

    private static void ensurePlayerIsACamera() {
        Entity camera;
        if (cutsceneExecutor != null && clientCameraEntity != null && !((camera = Minecraft.m_91087_().f_91075_) instanceof ClientCameraEntity)) {
            Minecraft.m_91087_().m_91118_((Entity)clientCameraEntity);
        }
    }

    public static void startCutscene(CutsceneData data) {
        Level level = FDClientHelpers.getClientLevel();
        Entity currentCamera = Minecraft.m_91087_().f_91075_;
        CutsceneScreenEffectData cutsceneScreenEffectData = data.getScreenEffectData();
        CutsceneExecutor.useScreenEffectsOnTick(cutsceneScreenEffectData, 0);
        CameraPos pos = data.getCameraPositions().get(0);
        if (!(currentCamera instanceof ClientCameraEntity) || clientCameraEntity == null) {
            ClientCameraEntity camera = new ClientCameraEntity(level);
            Vec3 p = pos.getPos();
            camera.m_146884_(p);
            camera.f_19854_ = p.f_82479_;
            camera.f_19855_ = p.f_82480_;
            camera.f_19856_ = p.f_82481_;
            Minecraft.m_91087_().m_91118_((Entity)camera);
            clientCameraEntity = camera;
        } else {
            Vec3 p = pos.getPos();
            currentCamera.m_146884_(p);
            currentCamera.f_19854_ = p.f_82479_;
            currentCamera.f_19855_ = p.f_82480_;
            currentCamera.f_19856_ = p.f_82481_;
        }
        cutsceneExecutor = new CutsceneExecutor(data);
    }

    public static void moveCamera(CutsceneData cutsceneData) {
        if (!CutsceneCameraHandler.isCutsceneActive()) {
            return;
        }
        cutsceneData = new CutsceneData(cutsceneData);
        CutsceneScreenEffectData screenEffects = cutsceneData.getScreenEffectData();
        CutsceneExecutor.useScreenEffectsOnTick(screenEffects, 0);
        Vec3 pos = cutsceneExecutor.getCameraPos();
        ObjectHolder<Float> yaw = new ObjectHolder<Float>(Float.valueOf(0.0f));
        ObjectHolder<Float> pitch = new ObjectHolder<Float>(Float.valueOf(0.0f));
        ObjectHolder<Float> roll = new ObjectHolder<Float>(Float.valueOf(0.0f));
        cutsceneExecutor.setCameraRotation(0.0f, yaw, pitch, roll);
        cutsceneData.addCameraPos(0, new CameraPos(pos, yaw.getValue().floatValue(), pitch.getValue().floatValue(), roll.getValue().floatValue()));
        cutsceneExecutor = new CutsceneExecutor(cutsceneData);
    }

    public static void stopCutscene() {
        if (CutsceneCameraHandler.isCutsceneActive()) {
            clientCameraEntity = null;
            cutsceneExecutor = null;
            MouseHandler mouseHandler = Minecraft.m_91087_().f_91067_;
            mouseHandler.f_91516_ = 0.0;
            mouseHandler.f_91517_ = 0.0;
            Minecraft.m_91087_().m_91118_((Entity)Minecraft.m_91087_().f_91074_);
        }
    }

    public static CutsceneExecutor getCutsceneExecutor() {
        return cutsceneExecutor;
    }

    public static boolean isCutsceneActive() {
        return clientCameraEntity != null && cutsceneExecutor != null;
    }
}

