/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.mixin;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.enchlevellangpatch.mixin.AbstractMixinPlugin;

public class ForgeMixinPlugin
extends AbstractMixinPlugin {
    private volatile Integer forgeVersion;
    private static final int V117 = 36;
    private static final int V1194 = 45;
    private static final int V1206 = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(String mixinPackage) {
        if (this.forgeVersion == null) {
            ForgeMixinPlugin forgeMixinPlugin = this;
            synchronized (forgeMixinPlugin) {
                if (this.forgeVersion == null) {
                    String forgeVersion = ForgeMixinPlugin.getForgeVersion();
                    this.forgeVersion = Integer.parseInt(forgeVersion.split("\\.", 2)[0]);
                }
            }
        }
    }

    @NotNull
    private static String getForgeVersion() {
        try {
            Class<?> clazz = Class.forName("net.neoforged.api.distmarker.Dist");
            return "-1";
        }
        catch (ClassNotFoundException clazz) {
            try {
                Class<?> clazz2 = Class.forName("net.minecraftforge.fml.loading.StringSubstitutor");
                MethodHandle mh = MethodHandles.lookup().findStatic(clazz2, "replace", MethodType.fromMethodDescriptorString("(Ljava/lang/String;Lnet/minecraftforge/fml/loading/moddiscovery/ModFile;)Ljava/lang/String;", clazz2.getClassLoader()));
                return mh.invoke("${global.forgeVersion}", null);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Not in Forge environment", e);
            }
        }
    }

    public String getRefMapperConfig() {
        if (this.forgeVersion < 0 || this.forgeVersion >= 50) {
            return null;
        }
        return this.forgeVersion >= 36 ? "ellp.refmap-117.json" : "ellp.refmap-116.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean b2 = mixinClassName.endsWith("1194");
        return (this.forgeVersion < 0 || this.forgeVersion >= 45) == b2;
    }
}

