/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.mixin;

import com.google.common.base.Suppliers;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.apiguardian.api.API;
import xland.mcmod.enchlevellangpatch.mixin.AbstractMixinPlugin;

public class FabricMixinPlugin
extends AbstractMixinPlugin {
    private static final Supplier<VersionPredicate> V1194_ABOVE = FabricMixinPlugin.parseVersionPredicate(">=1.19.4-");
    @API(status=API.Status.EXPERIMENTAL)
    private static final Supplier<VersionPredicate> V12112_ABOVE = FabricMixinPlugin.parseVersionPredicate(">=1.21.12-");
    private static final Supplier<VersionPredicate> PRE_25W44A = FabricMixinPlugin.parseVersionPredicate("<=1.21.11-alpha.25.44.a");
    private static final String UNOBFUSCATED_SUFFIX = "_unobfuscated";
    private Version minecraftVersion;
    private boolean is1194OrLater;

    private void initVersion() {
        ModContainer minecraft = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow(() -> new NoSuchElementException("minecraft"));
        this.minecraftVersion = minecraft.getMetadata().getVersion();
        this.is1194OrLater = V1194_ABOVE.get().test((Object)this.minecraftVersion);
    }

    public void onLoad(String mixinPackage) {
        this.initVersion();
    }

    public boolean isMojMapped() {
        Objects.requireNonNull(this.minecraftVersion);
        if (PRE_25W44A.get().test((Object)this.minecraftVersion)) {
            return false;
        }
        boolean laterThanMountsOfMayhem = V12112_ABOVE.get().test((Object)this.minecraftVersion);
        if (laterThanMountsOfMayhem) {
            return true;
        }
        return FabricLoader.getInstance().getRawGameVersion().endsWith(UNOBFUSCATED_SUFFIX);
    }

    public String getRefMapperConfig() {
        return this.isMojMapped() ? null : "enchlevel-langpatch-refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean b2 = mixinClassName.endsWith("1194");
        return this.is1194OrLater == b2;
    }

    private static Supplier<VersionPredicate> parseVersionPredicate(String predicate) {
        return Suppliers.memoize(() -> {
            try {
                return VersionPredicate.parse((String)predicate);
            }
            catch (VersionParsingException e) {
                throw new IllegalArgumentException("Invalid version predicate: " + predicate, e);
            }
        });
    }
}

