/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import xland.mcmod.enchlevellangpatch.impl.NumResultCacheMap;

final class ChineseExchange {
    private final NumResultCacheMap cacheMap = new NumResultCacheMap();
    private final String[] pos;
    private final char[] num;
    private final String[] sec;
    private final char zeroC;
    private final String zeroS;
    private final String tenOne;
    private static final ChineseExchange[] EXCHANGES = new ChineseExchange[]{new ChineseExchange(new String[]{"", "\u5341", "\u767e", "\u5343"}, new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'}, new String[]{"", "\u4e07", "\u4ebf", "\u4e07\u4ebf"}), new ChineseExchange(new String[]{"", "\u62fe", "\u4f70", "\u4edf"}, new char[]{'\u96f6', '\u58f9', '\u8cb3', '\u53c4', '\u8086', '\u4f0d', '\u9678', '\u67d2', '\u634c', '\u7396'}, new String[]{"", "\u842c", "\u5104", "\u842c\u5104"})};
    static final int NORMAL = 0;
    static final int UPPER = 1;

    ChineseExchange(String[] pos, char[] num, String[] sec) {
        this.pos = pos;
        this.num = num;
        this.sec = sec;
        this.zeroC = num[0];
        this.zeroS = String.valueOf(this.zeroC);
        this.tenOne = pos[1] + num[1];
    }

    @NotNull
    public static String numberToChinese(@Range(from=0L, to=0x7FFFFFFFL) int num, int type) {
        return EXCHANGES[type].numberToChinese(num);
    }

    String numberToChinese(int num) {
        return this.cacheMap.computeIfAbsent(num, this::numberToChinese0);
    }

    @NotNull
    private String numberToChinese0(int num) {
        if (num == 0) {
            return this.zeroS;
        }
        int sectionPosition = 0;
        StringBuilder ret = new StringBuilder();
        while (num > 0) {
            int section = num % 10000;
            if (section != 0) {
                ret.append(this.sec[sectionPosition]);
            }
            this.eachSection(section, ret);
            num /= 10000;
            ++sectionPosition;
        }
        int i = ret.length() - 1;
        if (this.zeroC == ret.charAt(i)) {
            ret.setLength(i);
        }
        if ((i = ret.length() - 2) < 0) {
            return ret.toString();
        }
        if (this.tenOne.equals(ret.substring(i))) {
            ret.setLength(++i);
        }
        return ret.reverse().toString();
    }

    private void eachSection(int num, StringBuilder ret) {
        boolean zero = true;
        for (int i = 0; i < 4; ++i) {
            int end = num % 10;
            if (end == 0) {
                if (!zero) {
                    zero = true;
                    ret.append(this.zeroC);
                }
            } else {
                zero = false;
                ret.append(this.pos[i]).append(this.num[end]);
            }
            num /= 10;
        }
    }
}

