/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatchConfig;
import xland.mcmod.enchlevellangpatch.impl.ConfigProvider;
import xland.mcmod.enchlevellangpatch.impl.IndependentLangPatchRegistry;
import xland.mcmod.enchlevellangpatch.impl.NamespacedKey;
import xland.mcmod.enchlevellangpatch.impl.NumberFormatUtil;

public final class LangPatchImpl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"LangPatch/Impl");
    public static final String KEY_ENCHANTMENT_TYPE = "langpatch.conf.enchantment.default.type";
    public static final String KEY_ENCHANTMENT_OVERRIDE = "langpatch.conf.enchantment.override";
    public static final String KEY_ENCHANTMENT_FORMAT = "enchantment.level.x";
    public static final String KEY_POTION_TYPE = "langpatch.conf.potion.default.type";
    public static final String KEY_POTION_OVERRIDE = "langpatch.conf.potion.override";
    public static final String KEY_POTION_FORMAT = "potion.potency.x";
    private static final List<ImmutablePair<Predicate<String>, EnchantmentLevelLangPatch>> PREDICATES = Collections.synchronizedList(Lists.newArrayList());
    private static final EnchantmentLevelLangPatch DEFAULT_ENCHANTMENT_HOOKS = (translationStorage, key) -> {
        String t;
        if (!Boolean.parseBoolean((String)translationStorage.get(KEY_ENCHANTMENT_OVERRIDE)) && (t = (String)translationStorage.get(key)) != null) {
            return t;
        }
        int lvl = Integer.parseInt(key.substring(18));
        return LangPatchImpl.configuredFormat(translationStorage, lvl, KEY_ENCHANTMENT_TYPE, KEY_ENCHANTMENT_FORMAT);
    };
    private static final EnchantmentLevelLangPatch DEFAULT_POTION_HOOKS = (translationStorage, key) -> {
        String t;
        if (!Boolean.parseBoolean((String)translationStorage.get(KEY_POTION_OVERRIDE)) && (t = (String)translationStorage.get(key)) != null) {
            return t;
        }
        int lvl = Integer.parseInt(key.substring(15)) + 1;
        return LangPatchImpl.configuredFormat(translationStorage, lvl, KEY_POTION_TYPE, KEY_POTION_FORMAT);
    };
    private static final EnchantmentLevelLangPatch ROMAN_ENCHANTMENT_HOOKS = DEFAULT_ENCHANTMENT_HOOKS::apply;
    private static final EnchantmentLevelLangPatch ROMAN_POTION_HOOKS = DEFAULT_POTION_HOOKS::apply;
    public static final IndependentLangPatchRegistry ENCHANTMENT_HOOK = IndependentLangPatchRegistry.of("enchantments");
    public static final IndependentLangPatchRegistry POTION_HOOK = IndependentLangPatchRegistry.of("potions");

    private LangPatchImpl() {
    }

    @NotNull
    private static String safeFormat(Map<String, String> translationStorage, String key, @NotNull Object arg) {
        try {
            return String.format(translationStorage.getOrDefault(key, "%s"), arg);
        }
        catch (IllegalFormatException e) {
            LOGGER.warn(MARKER, "Invalid format string for translation key {}. Using as-is format.", (Object)key, (Object)e);
            return arg.toString();
        }
    }

    @Nullable
    private static String configuredFormat(Map<String, String> translationStorage, int lvl, String configKey, String formatKey) {
        int cnMode;
        switch (translationStorage.getOrDefault(configKey, "").toLowerCase(Locale.ROOT)) {
            case "simplified": 
            case "chinese": 
            case "zh_normal": {
                cnMode = 0;
                break;
            }
            case "traditional": 
            case "zh_upper": {
                cnMode = 1;
                break;
            }
            case "numeral": 
            case "number": 
            case "numeric": 
            case "arabic": 
            case "": 
            case "null": 
            case "default": {
                return LangPatchImpl.safeFormat(translationStorage, formatKey, lvl);
            }
            case "skip": 
            case "skipped": 
            case "ignore": 
            case "ignored": {
                return null;
            }
            default: {
                cnMode = -1;
            }
        }
        return LangPatchImpl.safeFormat(translationStorage, formatKey, NumberFormatUtil.intToRomanImpl(lvl, cnMode));
    }

    public static void hookEnchantmentPatch(@NotNull NamespacedKey id, @NotNull EnchantmentLevelLangPatch hooks) {
        LangPatchImpl.hookPatch(ENCHANTMENT_HOOK, id, hooks);
    }

    public static void hookPotionPatch(@NotNull NamespacedKey id, @NotNull EnchantmentLevelLangPatch hooks) {
        LangPatchImpl.hookPatch(POTION_HOOK, id, hooks);
    }

    private static void hookPatch(IndependentLangPatchRegistry reg, NamespacedKey id, EnchantmentLevelLangPatch hooks) {
        if (reg.isFrozen()) {
            LOGGER.warn(MARKER, "{} is frozen. Patch {} may not be applied", (Object)reg, (Object)id);
            return;
        }
        reg.add(id, hooks);
    }

    public static void register(Predicate<String> keyPredicate, EnchantmentLevelLangPatch edition) {
        PREDICATES.add((ImmutablePair<Predicate<String>, EnchantmentLevelLangPatch>)ImmutablePair.of(keyPredicate, (Object)edition));
    }

    private static void lockAll() {
        ENCHANTMENT_HOOK.freeze();
        POTION_HOOK.freeze();
        LOGGER.debug(MARKER, "Registries are locked");
    }

    public static void init() {
        LangPatchImpl.applyConf4();
        LangPatchImpl.lockAll();
        EnchantmentLevelLangPatch.registerPatch(s -> s.startsWith("enchantment.level.") && NumberFormatUtil.isDigit(s, 18), (translationStorage, key) -> EnchantmentLevelLangPatchConfig.getCurrentEnchantmentHooks().apply(translationStorage, key));
        EnchantmentLevelLangPatch.registerPatch(s -> s.startsWith("potion.potency.") && NumberFormatUtil.isDigit(s, 15), (translationStorage, key) -> EnchantmentLevelLangPatchConfig.getCurrentPotionHooks().apply(translationStorage, key));
    }

    private static void applyConf4() {
        EnchantmentLevelLangPatch patch;
        ConfigProvider provider;
        Class<?> c2;
        try {
            c2 = Class.forName("xland.mcmod.enchlevellangpatch.ext.conf4.LangPatchConfigHooks");
            if (!ConfigProvider.class.isAssignableFrom(c2)) {
                LOGGER.warn(MARKER, "{} is not instance of ConfigProvider", c2);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug(MARKER, "Conf4 not detected");
            return;
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        LOGGER.debug(MARKER, "Detected Conf4");
        try {
            MethodHandle cons = lookup.findConstructor(c2, MethodType.methodType(Void.TYPE));
            provider = cons.invoke();
        }
        catch (Throwable t) {
            LOGGER.warn(MARKER, "Cannot instantiate {}", c2, (Object)t);
            return;
        }
        LOGGER.debug(MARKER, "Applying Conf4");
        Marker marker = MarkerManager.getMarker((String)"LangPatch/Conf4");
        String e = provider.getEnchantmentConfig();
        String p = provider.getPotionConfig();
        if (e != null) {
            patch = ENCHANTMENT_HOOK.get(NamespacedKey.of(e));
            EnchantmentLevelLangPatchConfig.setCurrentEnchantmentHooks(patch);
            LOGGER.info(marker, "Set enchantment hook to {}", (Object)e);
        }
        if (p != null) {
            patch = POTION_HOOK.get(NamespacedKey.of(p));
            EnchantmentLevelLangPatchConfig.setCurrentPotionHooks(patch);
            LOGGER.info(marker, "Set potion hook to {}", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void forEach(InterruptablePatchConsumer consumer) {
        List<ImmutablePair<Predicate<String>, EnchantmentLevelLangPatch>> list = PREDICATES;
        synchronized (list) {
            for (ImmutablePair<Predicate<String>, EnchantmentLevelLangPatch> pair : PREDICATES) {
                if (!consumer.interrupt((Predicate)pair.getLeft(), (EnchantmentLevelLangPatch)pair.getRight())) continue;
                return;
            }
        }
    }

    static {
        ENCHANTMENT_HOOK.add("enchlevel-langpatch:default", DEFAULT_ENCHANTMENT_HOOKS);
        POTION_HOOK.add("enchlevel-langpatch:default", DEFAULT_POTION_HOOKS);
        ENCHANTMENT_HOOK.add("enchlevel-langpatch:roman", ROMAN_ENCHANTMENT_HOOKS);
        POTION_HOOK.add("enchlevel-langpatch:roman", ROMAN_POTION_HOOKS);
    }

    @FunctionalInterface
    static interface InterruptablePatchConsumer {
        public boolean interrupt(Predicate<String> var1, EnchantmentLevelLangPatch var2);
    }
}

