/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.enchlevellangpatch.impl.ChineseExchange;
import xland.mcmod.enchlevellangpatch.impl.NumResultCacheMap;

public class NumberFormatUtil {
    private static final NumResultCacheMap CACHE = new NumResultCacheMap();
    private static final int[] I_ARR = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] S_ARR = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    static boolean isDigit(@NotNull String s, int offset) {
        int li = s.length() - 1;
        if (li < offset) {
            return false;
        }
        char c2 = s.charAt(offset);
        if (c2 == '0') {
            return li == offset;
        }
        for (int idx = li; idx >= offset; --idx) {
            c2 = s.charAt(idx);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String intToRoman(int num) {
        return CACHE.computeIfAbsent(num, NumberFormatUtil::intToRoman0);
    }

    private static String intToRoman0(int num) {
        StringBuilder res = new StringBuilder();
        if (num <= 0 || num >= 3999) {
            return null;
        }
        for (int i = 0; i < I_ARR.length; ++i) {
            for (int temp = num / I_ARR[i]; temp > 0; --temp) {
                res.append(S_ARR[i]);
            }
            num %= I_ARR[i];
        }
        return res.toString();
    }

    @NotNull
    static String intToRomanImpl(int i, int type) {
        if (i < 0) {
            return Integer.toString(i);
        }
        if (type >= 0) {
            return ChineseExchange.numberToChinese(i, type);
        }
        String ret = NumberFormatUtil.intToRoman(i);
        return ret == null ? Integer.toString(i) : ret;
    }
}

