/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.enchlevellangpatch.api;

import com.google.common.collect.BiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.enchlevellangpatch.impl.IndependentLangPatchRegistry;
import xland.mcmod.enchlevellangpatch.impl.LangPatchImpl;
import xland.mcmod.enchlevellangpatch.impl.NamespacedKey;

@API(status=API.Status.STABLE)
public final class EnchantmentLevelLangPatchConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"LangPatch/Config");
    @NotNull
    static volatile NamespacedKey currentEnchantmentHooksId = IndependentLangPatchRegistry.LP_DEFAULT;
    @NotNull
    static volatile NamespacedKey currentPotionHooksId = IndependentLangPatchRegistry.LP_DEFAULT;

    public static void setCurrentEnchantmentHooks(@Nullable EnchantmentLevelLangPatch hooks) {
        if (EnchantmentLevelLangPatchConfig.isEnchantmentHooksFrozen()) {
            LOGGER.warn(MARKER, "Enchantment Hooks is frozen. Changes may not be applied.");
            return;
        }
        currentEnchantmentHooksId = LangPatchImpl.ENCHANTMENT_HOOK.getId(hooks);
    }

    public static void setCurrentPotionHooks(@Nullable EnchantmentLevelLangPatch hooks) {
        if (EnchantmentLevelLangPatchConfig.isPotionHooksFrozen()) {
            LOGGER.warn(MARKER, "Potion Hooks is frozen. Changes may not be applied.");
            return;
        }
        currentPotionHooksId = LangPatchImpl.POTION_HOOK.getId(hooks);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static boolean isEnchantmentHooksFrozen() {
        return LangPatchImpl.ENCHANTMENT_HOOK.isFrozen();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static boolean isPotionHooksFrozen() {
        return LangPatchImpl.POTION_HOOK.isFrozen();
    }

    public static EnchantmentLevelLangPatch getCurrentEnchantmentHooks() {
        return LangPatchImpl.ENCHANTMENT_HOOK.get(currentEnchantmentHooksId);
    }

    public static EnchantmentLevelLangPatch getCurrentPotionHooks() {
        return LangPatchImpl.POTION_HOOK.get(currentPotionHooksId);
    }

    private EnchantmentLevelLangPatchConfig() {
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static @Unmodifiable BiMap<String, EnchantmentLevelLangPatch> getPotionHooksContext() {
        return LangPatchImpl.POTION_HOOK.asImmutableBiMap();
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static @Unmodifiable BiMap<String, EnchantmentLevelLangPatch> getEnchantmentHooksContext() {
        return LangPatchImpl.ENCHANTMENT_HOOK.asImmutableBiMap();
    }
}

