/*
 * Decompiled with CFR 0.152.
 */
package fuzs.proplacer.client.handler;

import fuzs.proplacer.ProPlacer;
import fuzs.proplacer.client.handler.KeyBindingHandler;
import fuzs.proplacer.config.ClientConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFastBlockHandler {
    @Nullable
    protected BlockPos blockPos;
    @Nullable
    private BlockPos newBlockPos;
    @Nullable
    protected Direction direction;

    public final void onStartClientTick(Minecraft minecraft) {
        if (!KeyBindingHandler.isFastPlacementActive() || !this.getKeyMapping(minecraft.options).isDown()) {
            this.clear();
        } else {
            this.tickNewPosition((Level)minecraft.level);
            if (this.isActive()) {
                this.tickWhenActive(minecraft);
            } else {
                this.tickNonActive(minecraft);
            }
        }
    }

    protected abstract void tickNonActive(Minecraft var1);

    protected abstract void tickWhenActive(Minecraft var1);

    protected void setNewBlockPos(BlockPos newBlockPos) {
        this.newBlockPos = newBlockPos;
    }

    protected BlockPos getTargetPosition() {
        return this.blockPos.relative(this.direction);
    }

    public boolean isActive() {
        return this.direction != null;
    }

    public void clear() {
        this.blockPos = null;
        this.direction = null;
    }

    private void tickNewPosition(Level level) {
        if (this.newBlockPos != null) {
            if (this.requireEmptyBlock() == level.isEmptyBlock(this.newBlockPos) && !((ClientConfig)ProPlacer.CONFIG.get(ClientConfig.class)).normalPlacement.contains((Object)level.getBlockState(this.newBlockPos).getBlock())) {
                if (this.blockPos != null && this.blockPos.distManhattan((Vec3i)this.newBlockPos) == 1) {
                    BlockPos diff = this.newBlockPos.subtract((Vec3i)this.blockPos);
                    this.direction = Direction.getNearest((int)diff.getX(), (int)diff.getY(), (int)diff.getZ(), null);
                } else {
                    this.direction = null;
                }
                this.blockPos = this.newBlockPos;
            }
            this.newBlockPos = null;
        }
    }

    protected abstract KeyMapping getKeyMapping(Options var1);

    protected abstract boolean requireEmptyBlock();
}

