/*
 * Decompiled with CFR 0.152.
 */
package fuzs.proplacer.client.handler;

import fuzs.proplacer.ProPlacer;
import fuzs.proplacer.client.handler.FastPlacementHandler;
import fuzs.proplacer.client.util.BlockClippingHelper;
import fuzs.proplacer.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ReachAroundPlacementHandler {
    private static boolean isProcessingInteraction;

    public static EventResult onUseInteraction(Minecraft minecraft, LocalPlayer player, InteractionHand interactionHand, HitResult hitResult) {
        BlockHitResult blockHitResult;
        if (!((ClientConfig)ProPlacer.CONFIG.get(ClientConfig.class)).allowReachAroundPlacement) {
            return EventResult.PASS;
        }
        if (!isProcessingInteraction && !FastPlacementHandler.INSTANCE.isActive() && (blockHitResult = ReachAroundPlacementHandler.getReachAroundHitResult(minecraft, player, hitResult)) != null) {
            isProcessingInteraction = true;
            InteractionResult interactionResult = ReachAroundPlacementHandler.startUseItemWithSecondaryUseActive(minecraft, player, interactionHand, blockHitResult);
            isProcessingInteraction = false;
            FastPlacementHandler.INSTANCE.clear();
            if (interactionResult.consumesAction()) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    @Nullable
    private static BlockHitResult getReachAroundHitResult(Minecraft minecraft, LocalPlayer player, HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.MISS && player.getViewXRot(0.0f) >= 45.0f) {
            BlockPos blockPos;
            BlockPos blockPos2 = blockPos = player.onGround() ? player.getOnPos() : player.blockPosition().below();
            if (!minecraft.level.isEmptyBlock(blockPos)) {
                Direction direction = player.getDirection();
                BlockPos targetPos = blockPos.relative(direction);
                if (BlockClippingHelper.isBlockPositionInLine((Entity)player, player.blockInteractionRange(), targetPos)) {
                    Vec3i directionNormal = direction.getUnitVec3i();
                    Vec3 hitLocation = new Vec3((double)directionNormal.getX(), (double)directionNormal.getY(), (double)directionNormal.getZ());
                    VoxelShape voxelShape = minecraft.level.getBlockState(blockPos).getCollisionShape((BlockGetter)minecraft.level, blockPos, CollisionContext.of((Entity)player));
                    double maxY = voxelShape.max(Direction.Axis.Y);
                    double minY = voxelShape.min(Direction.Axis.Y);
                    double y = Double.isInfinite(minY) || Double.isInfinite(maxY) ? Math.abs((Mth.frac((double)player.position().y()) - 0.5) * 2.0) : Mth.lerp((double)0.75, (double)minY, (double)maxY);
                    hitLocation = hitLocation.scale(0.5).add(0.5, y, 0.5).add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                    return new BlockHitResult(hitLocation, direction, blockPos, false);
                }
            }
        }
        return null;
    }

    public static InteractionResult startUseItemWithSecondaryUseActive(Minecraft minecraft, LocalPlayer player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        boolean shiftKeyDown = minecraft.player.input.keyPresses.shift() || !((ClientConfig)ProPlacer.CONFIG.get(ClientConfig.class)).bypassUseBlock;
        Input lastInput = minecraft.player.input.keyPresses;
        if (!shiftKeyDown) {
            Input input;
            minecraft.player.input.keyPresses = input = new Input(lastInput.forward(), lastInput.backward(), lastInput.left(), lastInput.right(), lastInput.jump(), true, lastInput.sprint());
            minecraft.player.connection.send((Packet)new ServerboundPlayerInputPacket(input));
        }
        InteractionResult interactionResult = ReachAroundPlacementHandler.startUseItem(minecraft, player, interactionHand, blockHitResult);
        if (!shiftKeyDown) {
            minecraft.player.input.keyPresses = lastInput;
            minecraft.player.connection.send((Packet)new ServerboundPlayerInputPacket(lastInput));
        }
        return interactionResult;
    }

    public static InteractionResult startUseItem(Minecraft minecraft, LocalPlayer player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        InteractionResult.Success success;
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        int itemCount = itemInHand.getCount();
        InteractionResult interactionResult = minecraft.gameMode.useItemOn(player, interactionHand, blockHitResult);
        if (interactionResult instanceof InteractionResult.Success && (success = (InteractionResult.Success)interactionResult).swingSource() == InteractionResult.SwingSource.CLIENT) {
            player.swing(interactionHand);
            if (!itemInHand.isEmpty() && (itemInHand.getCount() != itemCount || minecraft.player.hasInfiniteMaterials())) {
                minecraft.gameRenderer.itemInHandRenderer.itemUsed(interactionHand);
            }
        }
        return interactionResult;
    }
}

