/*
 * Decompiled with CFR 0.152.
 */
package fuzs.proplacer.client.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockClippingHelper {
    public static boolean isBlockPositionInLine(Entity entity, double pickRange, BlockPos targetPos) {
        Vec3 startVector = entity.getEyePosition(0.0f);
        Vec3 viewVector = entity.getViewVector(0.0f);
        Vec3 endVector = startVector.add(viewVector.x() * pickRange, viewVector.y() * pickRange, viewVector.z() * pickRange);
        ClipContext clipContext = new ClipContext(startVector, endVector, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity);
        return BlockClippingHelper.isBlockPositionInLine((BlockGetter)entity.level(), clipContext, targetPos);
    }

    public static boolean isBlockPositionInLine(BlockGetter blockGetter, ClipContext context, BlockPos targetPos) {
        return (Boolean)BlockGetter.traverseBlocks((Vec3)context.getFrom(), (Vec3)context.getTo(), (Object)context, (traverseContext, traversePos) -> {
            VoxelShape blockShape;
            Vec3 to;
            if (traversePos.equals((Object)targetPos)) {
                return Boolean.TRUE;
            }
            BlockState blockState = blockGetter.getBlockState(traversePos);
            FluidState fluidState = blockGetter.getFluidState(traversePos);
            Vec3 from = traverseContext.getFrom();
            BlockHitResult blockHitResult = blockGetter.clipWithInteractionOverride(from, to = traverseContext.getTo(), traversePos, blockShape = traverseContext.getBlockShape(blockState, blockGetter, traversePos), blockState);
            if (blockHitResult != null) {
                return Boolean.FALSE;
            }
            VoxelShape fluidShape = traverseContext.getFluidShape(fluidState, blockGetter, traversePos);
            BlockHitResult fluidHitResult = fluidShape.clip(from, to, traversePos);
            return fluidHitResult != null ? Boolean.FALSE : null;
        }, failContext -> Boolean.FALSE);
    }
}

