package rege.rege.misc.searchworldenhance.util;

import java.util.Objects;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class EnumItem<T extends Enum<T>> implements MatchItem<@Nullable T> {
    public final @Nullable T pattern;
    public final boolean negated;

    @Contract(pure = true)
    public EnumItem(@Nullable T pattern, boolean negated) {
        this.pattern = pattern;
        this.negated = negated;
    }

    @Override
    @Contract(value = "null -> false", pure = true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumItem)) {
            return false;
        }
        EnumItem<?> that = (EnumItem<?>)o;
        return this.negated == that.negated && this.pattern == that.pattern;
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode(this.pattern);
        result = 31 * result + Boolean.hashCode(this.negated);
        return result;
    }

    @Override
    @Contract(pure = true)
    public boolean matches(@Nullable T target) {
        return (this.pattern == target) != this.negated;
    }
}
