/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.searchworldenhance;

import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.client.class_2847;
import net.minecraft.client.class_2848;
import net.minecraft.client.font.TextRenderer;
import net.minecraft.client.gui.screen.world.SelectWorldScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import rege.rege.minecraftmod.searchworldenhance.mixin.WorldListEntryAccessor;
import rege.rege.minecraftmod.searchworldenhance.mixin.WorldListWidgetAccessor;
import rege.rege.minecraftmod.searchworldenhance.util.GamemodeNames;
import rege.rege.minecraftmod.searchworldenhance.util.SearchKeyRegistry;

public class SearchWorldEnhanceMain
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger(SearchWorldEnhanceMain.class);
    private static final WeakHashMap<@NotNull SelectWorldScreen, TextFieldWidget> SEARCH_BOXES = new WeakHashMap();
    public static final int SEARCH_BOX_ID = 305915250;

    @Contract(value="_, _, _, _, _, _ -> new")
    public static TextFieldWidget createSearchBox(@NotNull SelectWorldScreen screen, TextRenderer tr, int x, int y, int width, int height) {
        TextFieldWidget BOX = new TextFieldWidget(305915250, tr, x, y, width, height);
        SEARCH_BOXES.put(screen, BOX);
        return BOX;
    }

    public static String getSearchBoxString(@NotNull SelectWorldScreen screen) {
        return SEARCH_BOXES.get(screen).getText();
    }

    public static boolean setSearchBoxString(@NotNull SelectWorldScreen screen, String str) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.setText(str);
        return true;
    }

    public static boolean setSearchBoxMaxLength(@NotNull SelectWorldScreen screen, int length) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.setMaxLength(length);
        return true;
    }

    public static Integer getSearchBoxX(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        return BOX == null ? null : Integer.valueOf(BOX.x);
    }

    public static Integer getSearchBoxY(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        return BOX == null ? null : Integer.valueOf(BOX.y);
    }

    public static boolean renderSearchBox(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.render();
        return true;
    }

    public static boolean tickSearchBox(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.tick();
        return true;
    }

    public static boolean focusSearchBox(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.setFocused(true);
        BOX.setFocusUnlocked(false);
        return true;
    }

    public static boolean isSearchBoxFocused(@NotNull SelectWorldScreen screen) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        return BOX != null && BOX.isFocused();
    }

    public static boolean clickSearchBox(@NotNull SelectWorldScreen screen, int mouseX, int mouseY, int button) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.mouseClicked(mouseX, mouseY, button);
        return true;
    }

    public static boolean typeOnSearchBox(@NotNull SelectWorldScreen screen, char id, int code) {
        TextFieldWidget BOX = SEARCH_BOXES.get(screen);
        return BOX != null && BOX.keyPressed(id, code);
    }

    public static void refilterWorldList(class_2848 worldList, @NotNull Predicate<class_2847> predicate) {
        ((WorldListWidgetAccessor)worldList).getWorldEntryList().removeIf(predicate.negate());
    }

    @Contract(pure=true)
    public void onInitializeClient() {
    }

    static {
        SearchKeyRegistry.registerRegex("worldname", (regex, entry) -> regex.matches(((WorldListEntryAccessor)entry).getLevelSummary().getDisplayName()));
        SearchKeyRegistry.registerRegex("worlddirname", (regex, entry) -> regex.matches(((WorldListEntryAccessor)entry).getLevelSummary().getFileName()));
        SearchKeyRegistry.registerLong("lastplayed", (long_, entry) -> long_.matches(((WorldListEntryAccessor)entry).getLevelSummary().getLastPlayed()));
        SearchKeyRegistry.registerEnum("gamemode", GamemodeNames.class, (mode, entry) -> mode.matches(GamemodeNames.of(((WorldListEntryAccessor)entry).getLevelSummary().getGameMode())));
        SearchKeyRegistry.registerBool("commands", (bool, entry) -> bool.matches(((WorldListEntryAccessor)entry).getLevelSummary().cheatsEnabled()));
        SearchKeyRegistry.registerBool("hardcore", (bool, entry) -> bool.matches(((WorldListEntryAccessor)entry).getLevelSummary().isHardcore()));
    }
}

