/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.misc.searchworldenhance.util;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import rege.rege.misc.searchworldenhance.util.MatchItem;

public class RegexItem
implements MatchItem<String> {
    @NotNull
    public final String pattern;
    public final boolean ignoreCase;
    public final boolean isRegex;
    public final boolean negated;

    @Contract(pure=true)
    public RegexItem(@NotNull String pattern, boolean ignoreCase, boolean isRegex, boolean negated) {
        this.pattern = ignoreCase && !isRegex ? pattern.toLowerCase() : pattern;
        this.ignoreCase = ignoreCase;
        this.isRegex = isRegex;
        this.negated = negated;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexItem)) {
            return false;
        }
        RegexItem that = (RegexItem)o;
        return this.pattern.equals(that.pattern) && this.ignoreCase == that.ignoreCase && this.isRegex == that.isRegex && this.negated == that.negated;
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.ignoreCase, this.isRegex, this.negated);
    }

    @Override
    public boolean matches(@NotNull String target) {
        return (this.isRegex ? (this.ignoreCase ? Pattern.compile(this.pattern, 2) : Pattern.compile(this.pattern)).matcher(target).find() : (this.ignoreCase ? target.toLowerCase() : target).contains(this.pattern)) != this.negated;
    }
}

