/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.searchworldenhance.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2847;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rege.rege.minecraftmod.NoMc;
import rege.rege.misc.searchworldenhance.util.BoolItem;
import rege.rege.misc.searchworldenhance.util.EnumItem;
import rege.rege.misc.searchworldenhance.util.NumberItem;
import rege.rege.misc.searchworldenhance.util.RegexItem;

public abstract class SearchKeyRegistry {
    private static final ArrayList<@NotNull String> TRUE_STRINGS = new ArrayList(5);
    private static final ArrayList<@NotNull String> FALSE_STRINGS = new ArrayList(5);
    private static final HashMap<@NotNull String, @NotNull BiPredicate<@NotNull RegexItem, class_2847>> REGEX_REGISTRIES = new HashMap();
    private static final HashMap<@NotNull String, @NotNull BiPredicate<@NotNull NumberItem<Long>, class_2847>> LONG_REGISTRIES = new HashMap();
    private static final HashMap<@NotNull String, Map.Entry<Class<Enum<?>>, @NotNull BiPredicate<@NotNull EnumItem<?>, class_2847>>> ENUM_REGISTRIES = new HashMap();
    private static final HashMap<@NotNull String, @NotNull BiPredicate<@NotNull BoolItem, class_2847>> BOOL_REGISTRIES = new HashMap();

    @NoMc
    public static String validateKey(@NotNull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Keys must be not empty");
        }
        if (key.indexOf(45) != -1 || key.indexOf(32) != -1 || key.indexOf(61) != -1 || key.indexOf(33) != -1 || key.indexOf(62) != -1 || key.indexOf(60) != -1 || key.indexOf(44) != -1 || key.indexOf(47) != -1 || key.indexOf(34) != -1 || key.indexOf(92) != -1) {
            throw new IllegalArgumentException("Keys cannot contain space and -=!><,/\"\\");
        }
        return key;
    }

    public static void registerRegex(@NotNull String key, @NotNull @NotNull BiPredicate<@NotNull RegexItem, class_2847> predicate) {
        REGEX_REGISTRIES.put(SearchKeyRegistry.validateKey(key), predicate);
    }

    public static void registerLong(@NotNull String key, @NotNull @NotNull BiPredicate<@NotNull NumberItem<Long>, class_2847> predicate) {
        LONG_REGISTRIES.put(SearchKeyRegistry.validateKey(key), predicate);
    }

    public static <T extends Enum<T>> void registerEnum(@NotNull String key, final @NotNull Class<T> clazz, final @NotNull @NotNull BiPredicate<@NotNull EnumItem<T>, class_2847> predicate) {
        Map.Entry ENTRY = new Map.Entry<Class<T>, BiPredicate<EnumItem<T>, class_2847>>(){

            @Override
            @Contract(pure=true)
            @NotNull
            public Class<T> getKey() {
                return clazz;
            }

            @Override
            @Contract(pure=true)
            @NotNull
            public BiPredicate<EnumItem<T>, class_2847> getValue() {
                return predicate;
            }

            @Override
            @Contract(value="_ -> fail")
            public BiPredicate<EnumItem<T>, class_2847> setValue(BiPredicate<EnumItem<T>, class_2847> enumItemclass2847BiPredicate) {
                throw new UnsupportedOperationException();
            }
        };
        ENUM_REGISTRIES.put(SearchKeyRegistry.validateKey(key), ENTRY);
    }

    public static void registerBool(@NotNull String key, @NotNull @NotNull BiPredicate<@NotNull BoolItem, class_2847> predicate) {
        BOOL_REGISTRIES.put(SearchKeyRegistry.validateKey(key), predicate);
    }

    @Nullable
    public static Predicate<class_2847> evaluate(@NotNull String str) throws IndexOutOfBoundsException {
        int ptr = 0;
        Predicate<class_2847> result = null;
        do {
            StringBuilder sb = new StringBuilder();
            while ("- =!><,/\"\\".indexOf(str.charAt(ptr)) == -1) {
                sb.append(str.charAt(ptr));
                ++ptr;
            }
            String KEY = sb.toString();
            try {
                SearchKeyRegistry.validateKey(KEY);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (REGEX_REGISTRIES.containsKey(KEY)) {
                boolean negated = false;
                boolean ignoreCase = true;
                boolean isRegex = false;
                boolean end = false;
                while (!end) {
                    switch ("=!-/".indexOf(str.charAt(ptr))) {
                        case 0: {
                            end = true;
                            break;
                        }
                        case 1: {
                            negated = !negated;
                            break;
                        }
                        case 2: {
                            ignoreCase = false;
                            break;
                        }
                        case 3: {
                            isRegex = true;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    ++ptr;
                }
                if (str.charAt(ptr) == '\"') {
                    ++ptr;
                    sb = new StringBuilder();
                    boolean escaped = false;
                    while (true) {
                        char ach = str.charAt(ptr);
                        if (escaped) {
                            escaped = false;
                            sb.append(ach);
                        } else if (ach == '\\') {
                            escaped = true;
                        } else if (ach == '\"') {
                            ++ptr;
                            break;
                        }
                        ++ptr;
                    }
                    String PATTERN = sb.toString();
                    if (isRegex) {
                        try {
                            Pattern.compile(PATTERN);
                        }
                        catch (PatternSyntaxException e) {
                            return null;
                        }
                    }
                    RegexItem ITEM = new RegexItem(PATTERN, ignoreCase, isRegex, negated);
                    Predicate<class_2847> predicate = entry -> REGEX_REGISTRIES.get(KEY).test(ITEM, (class_2847)entry);
                    Predicate<class_2847> predicate2 = result = result == null ? predicate : result.and(predicate);
                    if (ptr >= str.length()) {
                        return result;
                    }
                    if (str.charAt(ptr) != ',') {
                        return null;
                    }
                    ++ptr;
                    continue;
                }
                sb = new StringBuilder();
                try {
                    while (true) {
                        char ach;
                        if ((ach = str.charAt(ptr)) == ',') {
                            ++ptr;
                            break;
                        }
                        sb.append(ach);
                        ++ptr;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                String PATTERN = sb.toString();
                if (isRegex) {
                    try {
                        Pattern.compile(PATTERN);
                    }
                    catch (PatternSyntaxException e) {
                        return null;
                    }
                }
                RegexItem ITEM = new RegexItem(PATTERN, ignoreCase, isRegex, negated);
                Predicate<class_2847> predicate = entry -> REGEX_REGISTRIES.get(KEY).test(ITEM, (class_2847)entry);
                result = result == null ? predicate : result.and(predicate);
                continue;
            }
            if (LONG_REGISTRIES.containsKey(KEY)) {
                int mark = 32;
                boolean hasEq = false;
                switch (str.charAt(ptr)) {
                    case '=': {
                        mark = 61;
                        break;
                    }
                    case '>': {
                        mark = 62;
                        break;
                    }
                    case '<': {
                        mark = 60;
                        break;
                    }
                    case '!': {
                        mark = 33;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (str.charAt(++ptr) == '=') {
                    hasEq = true;
                    ++ptr;
                }
                sb = new StringBuilder();
                try {
                    while (true) {
                        char ach;
                        if ((ach = str.charAt(ptr)) == ',') {
                            ++ptr;
                            break;
                        }
                        sb.append(ach);
                        ++ptr;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                try {
                    long PATTERN = Long.parseLong(sb.toString());
                    NumberItem<Long> ITEM = new NumberItem<Long>(PATTERN, mark == 33 || mark == 60, mark == 61 || mark != 33 && hasEq, mark == 33 || mark == 62);
                    Predicate<class_2847> predicate = entry -> LONG_REGISTRIES.get(KEY).test(ITEM, (class_2847)entry);
                    result = result == null ? predicate : result.and(predicate);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (ENUM_REGISTRIES.containsKey(KEY)) {
                boolean negated = false;
                if (str.charAt(ptr) == '!') {
                    negated = true;
                    ++ptr;
                }
                if (str.charAt(ptr) != '=') {
                    return null;
                }
                ++ptr;
                sb = new StringBuilder();
                try {
                    while (true) {
                        char ach;
                        if ((ach = str.charAt(ptr)) == ',') {
                            ++ptr;
                            break;
                        }
                        sb.append(ach);
                        ++ptr;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                try {
                    String VALUE = sb.toString();
                    Enum<?> PATTERN = "null".equals(VALUE) ? null : Enum.valueOf(ENUM_REGISTRIES.get(KEY).getKey(), VALUE);
                    EnumItem<Object> ITEM = new EnumItem<Object>(PATTERN, negated);
                    Predicate<class_2847> predicate = entry -> ENUM_REGISTRIES.get(KEY).getValue().test(ITEM, (class_2847)entry);
                    result = result == null ? predicate : result.and(predicate);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (BOOL_REGISTRIES.containsKey(KEY)) {
                Predicate<class_2847> predicate;
                BoolItem ITEM;
                if (str.charAt(ptr) != '=') {
                    return null;
                }
                ++ptr;
                sb = new StringBuilder();
                try {
                    while (true) {
                        char ach;
                        if ((ach = str.charAt(ptr)) == ',') {
                            ++ptr;
                            break;
                        }
                        sb.append(ach);
                        ++ptr;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                String VALUE = sb.toString().toLowerCase();
                if (TRUE_STRINGS.contains(VALUE)) {
                    ITEM = new BoolItem(true);
                    predicate = entry -> BOOL_REGISTRIES.get(KEY).test(ITEM, (class_2847)entry);
                    result = result == null ? predicate : result.and(predicate);
                    continue;
                }
                if (FALSE_STRINGS.contains(VALUE)) {
                    ITEM = new BoolItem(false);
                    predicate = entry -> BOOL_REGISTRIES.get(KEY).test(ITEM, (class_2847)entry);
                    result = result == null ? predicate : result.and(predicate);
                    continue;
                }
                return null;
            }
            return null;
        } while (ptr < str.length());
        return result;
    }

    @Contract(value="-> fail")
    private SearchKeyRegistry() {
        throw new UnsupportedOperationException();
    }

    static {
        TRUE_STRINGS.add("true");
        TRUE_STRINGS.add("yes");
        TRUE_STRINGS.add("t");
        TRUE_STRINGS.add("y");
        TRUE_STRINGS.add("1");
        FALSE_STRINGS.add("false");
        FALSE_STRINGS.add("no");
        FALSE_STRINGS.add("f");
        FALSE_STRINGS.add("n");
        FALSE_STRINGS.add("0");
    }
}

