/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.misc.searchworldenhance.util;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import rege.rege.misc.searchworldenhance.util.MatchItem;

public class NumberItem<T extends Number>
implements MatchItem<T> {
    @NotNull
    public final T pattern;
    public final boolean allowLess;
    public final boolean allowEqual;
    public final boolean allowGreater;

    public NumberItem(@NotNull T pattern, boolean allowLess, boolean allowEqual, boolean allowGreater) {
        this.pattern = pattern;
        this.allowLess = allowLess;
        this.allowEqual = allowEqual;
        this.allowGreater = allowGreater;
    }

    @Contract(value="null -> false")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumberItem)) {
            return false;
        }
        NumberItem that = (NumberItem)o;
        return this.allowLess == that.allowLess && this.allowEqual == that.allowEqual && this.allowGreater == that.allowGreater && this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.allowLess, this.allowEqual, this.allowGreater);
    }

    @Override
    public boolean matches(@NotNull T target) {
        int CMP = ((Comparable)target).compareTo(this.pattern);
        return this.allowLess && CMP < 0 || this.allowEqual && CMP == 0 || this.allowGreater && CMP > 0;
    }
}

