package rege.rege.minecraftmod.searchworldenhance;

import org.apache.logging.log4j.Logger;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2847;
import net.minecraft.class_2848;
import net.minecraft.class_367;
import net.minecraft.class_370;
import net.minecraft.class_391;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import rege.rege.minecraftmod.searchworldenhance.mixin.WorldListEntryAccessor;
import rege.rege.minecraftmod.searchworldenhance.mixin.WorldListWidgetAccessor;
import rege.rege.minecraftmod.searchworldenhance.util.GamemodeNames;

import java.util.WeakHashMap;
import java.util.function.Predicate;

import static org.apache.logging.log4j.LogManager.getLogger;
import static rege.rege.minecraftmod.searchworldenhance.util.SearchKeyRegistry.registerBool;
import static rege.rege.minecraftmod.searchworldenhance.util.SearchKeyRegistry.registerEnum;
import static rege.rege.minecraftmod.searchworldenhance.util.SearchKeyRegistry.registerLong;
import static rege.rege.minecraftmod.searchworldenhance.util.SearchKeyRegistry.registerRegex;

public class SearchWorldEnhanceMain implements ClientModInitializer {
    public static final Logger LOGGER =getLogger(SearchWorldEnhanceMain.class);
    private static final
    WeakHashMap<@NotNull class_391, class_367> SEARCH_BOXES =
    new WeakHashMap<>();
    public static final int SEARCH_BOX_ID = 305915250;

    @Contract("_, _, _, _, _, _ -> new")
    public static class_367 createSearchBox(
        @NotNull class_391 screen, class_370 tr, int x, int y,
        int width, int height
    ) {
        final class_367 BOX = new class_367(
            SEARCH_BOX_ID, tr, x, y, width, height
        );
        SEARCH_BOXES.put(screen, BOX);
        return BOX;
    }

    public static String getSearchBoxString(@NotNull class_391 screen){
        return SEARCH_BOXES.get(screen).method_924();
    }

    public static boolean
    setSearchBoxString(@NotNull class_391 screen, String str) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.method_922(str);
        return true;
    }

    public static boolean
    setSearchBoxMaxLength(@NotNull class_391 screen, int length) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.method_938(length);
        return true;
    }

    public static Integer getSearchBoxX(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        return (BOX == null) ? null : BOX.field_1117;
    }

    public static Integer getSearchBoxY(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        return (BOX == null) ? null : BOX.field_1118;
    }

    public static boolean renderSearchBox(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.method_937();
        return true;
    }

    public static boolean tickSearchBox(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.method_916();
        return true;
    }

    public static boolean focusSearchBox(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        if (BOX == null) {
            return false;
        }
        BOX.method_927(true);
        BOX.method_933(false);
        return true;
    }

    public static boolean
    isSearchBoxFocused(@NotNull class_391 screen) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        return BOX != null && BOX.method_944();
    }

    public static boolean clickSearchBox(
        @NotNull class_391 screen, int mouseX, int mouseY, int button
    ) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        return BOX != null && BOX.method_920(mouseX, mouseY, button);
    }

    public static boolean
    typeOnSearchBox(@NotNull class_391 screen, char id, int code) {
        final class_367 BOX = SEARCH_BOXES.get(screen);
        return BOX != null && BOX.method_917(id, code);
    }

    public static void refilterWorldList(
        class_2848 worldList, @NotNull Predicate<class_2847> predicate
    ) {
        ((WorldListWidgetAccessor)worldList).getWorldEntryList()
        .removeIf(predicate.negate());
    }

    static {
        registerRegex("worldname", (regex, entry) -> regex.matches(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_258()
        ));
        registerRegex("worlddirname", (regex, entry) -> regex.matches(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_256()
        ));
        registerLong("lastplayed", (long_, entry) -> long_.matches(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_260()
        ));
        registerEnum("gamemode", GamemodeNames.class,
                     (mode, entry) -> mode.matches(GamemodeNames.of(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_261()
        )));
        registerBool("commands", (bool, entry) -> bool.matches(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_263()
        ));
        registerBool("hardcore", (bool, entry) -> bool.matches(
            ((WorldListEntryAccessor)entry).getLevelSummary().method_262()
        ));
    }

    @Override
    @Contract(pure = true)
    public void onInitializeClient() {}
}
