package rege.rege.misc.searchworldenhance.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BoolItem implements MatchItem<@NotNull Boolean> {
    public final boolean pattern;

    @Contract(pure = true)
    public BoolItem(boolean pattern) {
        this.pattern = pattern;
    }

    @Override
    @Contract(value = "null -> false", pure = true)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoolItem)) {
            return false;
        }
        return this.pattern == ((BoolItem)o).pattern;
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.pattern);
    }

    @Override
    @Contract(pure = true)
    public boolean matches(@NotNull Boolean target) {
        return this.pattern == target.booleanValue();
    }
}
