/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.arsenal.item.Group;
import net.arsenal.item.Loot;
import net.arsenal.spell.ArsenalSpells;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class ArsenalBows {
    public static final ArrayList<RangedEntry> entries = new ArrayList();
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2 = class_1834.field_8930.method_8025();
    private static final int durabilityTier3 = class_1834.field_22033.method_8025();
    private static final int durabilityTier4 = durabilityTier3 * 2;
    private static final float pullTime_shortBow = -0.19999999f;
    private static final float pullTime_longBow = 0.5f;
    private static final float pullTime_rapidCrossbow = 0.0f;
    private static final float pullTime_heavyCrossbow = 0.75f;
    private static final float velocity_shortBow = 0.0f;
    private static final float velocity_longBow = 0.75f;
    private static final float velocity_rapidCrossbow = 0.0f;
    private static final float velocity_heavyCrossbow = 0.5f;
    public static RangedEntry unique_longbow_1 = ArsenalBows.bow("unique_longbow_1", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Sunfury Hawk-Bow").spell(ArsenalSpells.radiance_ranged.id()).loot(5, Loot.Theme.DIVINE.toString());
    public static RangedEntry unique_longbow_2 = ArsenalBows.bow("unique_longbow_2", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22021}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Black Bow of the Betrayer").spell(ArsenalSpells.wither_ranged.id()).loot(5, Loot.Theme.EVIL.toString());
    public static RangedEntry unique_longbow_sw = ArsenalBows.bow("unique_longbow_sw", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Golden Bow of Quel'Thalas").spell(ArsenalSpells.rampaging_ranged.id()).loot(5, Loot.Theme.ELVEN.toString());
    public static RangedEntry unique_heavy_crossbow_1 = ArsenalBows.crossbow("unique_heavy_crossbow_1", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22021}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Heavy Crossbow of the Phoenix").spell(ArsenalSpells.flame_cloud_ranged.id()).loot(5, Loot.Theme.FIERY.toString());
    public static RangedEntry unique_heavy_crossbow_2 = ArsenalBows.crossbow("unique_heavy_crossbow_2", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Necropolis Ballista").spell(ArsenalSpells.poison_cloud_ranged.id()).loot(5, Loot.Theme.EVIL.toString());
    public static RangedEntry unique_heavy_crossbow_sw = ArsenalBows.crossbow("unique_heavy_crossbow_sw", durabilityTier4, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8494}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Crossbow of Relentless Strikes").spell(ArsenalSpells.bonus_shot_ranged.id()).loot(5, Loot.Theme.ELVEN.toString());

    private static RangedEntry bow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"arsenal", (String)name), CustomBow::new, defaults, repairIngredientSupplier, durability);
        entry.weaponAttributesPreset = "bow_two_handed_heavy";
        entry.weaponType = Equipment.WeaponType.LONG_BOW;
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<class_1856> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(class_2960.method_60655((String)"arsenal", (String)name), CustomCrossbow::new, defaults, repairIngredientSupplier, durability);
        entry.weaponAttributesPreset = "crossbow_two_handed_heavy";
        entry.weaponType = Equipment.WeaponType.HEAVY_CROSSBOW;
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, RangedConfig> rangedConfig) {
        int netheriteTier = Tiers.unsafe((String)"netherite");
        for (RangedEntry entry : entries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            class_1792.class_1793 settings = new class_1792.class_1793();
            int tier = Tiers.unsafe((class_2960)entry.id());
            if (tier >= netheriteTier) {
                settings.method_24359();
            }
            if (entry.rarity != class_1814.field_8906) {
                settings.method_7894(entry.rarity);
            }
            if (entry.spells != null) {
                if (entry.spells.isEmpty()) {
                    settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon());
                } else {
                    settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon(entry.spells));
                }
            }
            class_1792 item = entry.create(settings, config);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id, (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (RangedEntry entry : entries) {
                content.method_45421((class_1935)entry.item);
            }
        });
    }

    static {
        for (RangedEntry entry : entries) {
            entry.rarity = class_1814.field_8903;
        }
    }

    public static final class RangedEntry {
        private final class_2960 id;
        private final RangedFactory factory;
        private final RangedConfig defaults;
        private final Supplier<class_1856> repairIngredientSupplier;
        private final int durability;
        public String weaponAttributesPreset;
        private String translatedName = "";
        public class_1814 rarity = class_1814.field_8906;
        public class_1792 item;
        public List<class_2960> spells = null;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;
        public Equipment.WeaponType weaponType = Equipment.WeaponType.LONG_BOW;

        public RangedEntry(class_2960 id, RangedFactory factory, RangedConfig defaults, Supplier<class_1856> repairIngredientSupplier, int durability) {
            this.id = id;
            this.factory = factory;
            this.defaults = defaults;
            this.repairIngredientSupplier = repairIngredientSupplier;
            this.durability = durability;
        }

        public class_2960 id() {
            return this.id;
        }

        public RangedFactory factory() {
            return this.factory;
        }

        public RangedConfig defaults() {
            return this.defaults;
        }

        public Supplier<class_1856> repairIngredientSupplier() {
            return this.repairIngredientSupplier;
        }

        public int durability() {
            return this.durability;
        }

        public class_1792 create(class_1792.class_1793 settings, RangedConfig config) {
            this.item = this.factory.create(settings.method_7895(this.durability), config, this.repairIngredientSupplier);
            return this.item;
        }

        public class_1792 item() {
            return this.item;
        }

        public RangedEntry translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public String translationKey() {
            return class_156.method_646((String)"item", (class_2960)this.id());
        }

        public RangedEntry castSpell() {
            this.spells = List.of();
            return this;
        }

        public RangedEntry spell(class_2960 spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public RangedEntry loot(int tier, String theme) {
            this.lootProperties = Equipment.LootProperties.of((int)tier, (String)theme);
            return this;
        }
    }

    public static interface RangedFactory {
        public class_1792 create(class_1792.class_1793 var1, RangedConfig var2, Supplier<class_1856> var3);
    }
}

