/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.arsenal.item.Group;
import net.arsenal.item.Loot;
import net.arsenal.spell.ArsenalSpells;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class ArsenalWeapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    public static final float TIER_5_SPELL_POWER = 7.0f;
    public static final Weapon.Entry unique_claymore_1 = ArsenalWeapons.claymore("unique_claymore_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_BLOCK})), 13.0f).translatedName("Cataclysm's Edge").spell(ArsenalSpells.exploding_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FIERY.toString()));
    public static final Weapon.Entry unique_claymore_2 = ArsenalWeapons.claymore("unique_claymore_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK})), 13.0f).translatedName("Champion's Greatsword").spell(ArsenalSpells.radiance_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.DIVINE.toString()));
    public static final Weapon.Entry unique_claymore_sw = ArsenalWeapons.claymore("unique_claymore_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 13.0f).translatedName("Apolyon, the Soul-Render").spell(ArsenalSpells.rampaging_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_staff_damage_1 = ArsenalWeapons.damage_staff("unique_staff_damage_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).translatedName("Nexus Key").spell(ArsenalSpells.cooldown_shot_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.GENERIC.toString()));
    public static final Weapon.Entry unique_staff_damage_2 = ArsenalWeapons.damage_staff("unique_staff_damage_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)7.0f)).translatedName("Antonidas's Staff of Rapt Concentration").spell(ArsenalSpells.chain_reaction_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.CRYSTAL.toString()));
    public static final Weapon.Entry unique_staff_damage_3 = ArsenalWeapons.damage_staff("unique_staff_damage_3", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)7.0f)).translatedName("Draconic Battle Staff").spell(ArsenalSpells.flame_cloud_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FIERY.toString()));
    public static final Weapon.Entry unique_staff_damage_4 = ArsenalWeapons.damage_staff("unique_staff_damage_4", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).translatedName("Gargoyle's Bite").spell(ArsenalSpells.leeching_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.EVIL.toString()));
    public static final Weapon.Entry unique_staff_damage_5 = ArsenalWeapons.damage_staff("unique_staff_damage_5", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).translatedName("Mage Lord Cane").spell(ArsenalSpells.shockwave_area_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.GENERIC.toString()));
    public static final Weapon.Entry unique_staff_damage_6 = ArsenalWeapons.damage_staff("unique_staff_damage_6", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).translatedName("Endless Winter").spell(ArsenalSpells.frost_cloud_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FROSTY.toString()));
    public static final Weapon.Entry unique_staff_damage_sw = ArsenalWeapons.damage_staff("unique_staff_damage_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).translatedName("Grand Magister's Staff of Torrents").spell(ArsenalSpells.rampaging_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_staff_heal_1 = ArsenalWeapons.healing_staff("unique_staff_heal_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)7.0f)).translatedName("Crystalline Life-Staff").spell(ArsenalSpells.radiance_spell.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.CRYSTAL.toString()));
    public static final Weapon.Entry unique_staff_heal_2 = ArsenalWeapons.healing_staff("unique_staff_heal_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)7.0f)).translatedName("Staff of Immaculate Recovery").spell(ArsenalSpells.guardian_heal.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.DIVINE.toString()));
    public static final Weapon.Entry unique_staff_heal_sw = ArsenalWeapons.healing_staff("unique_staff_heal_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.HEALING.id, (float)7.0f)).translatedName("Golden Staff of the Sin'dorei").spell(ArsenalSpells.cooldown_heal.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_spear_1 = ArsenalWeapons.spear("unique_spear_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 8.0f).translatedName("Sonic Spear").spell(ArsenalSpells.slowing_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.GENERIC.toString()));
    public static final Weapon.Entry unique_spear_2 = ArsenalWeapons.spear("unique_spear_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 8.0f).translatedName("Spear of the Damned").spell(ArsenalSpells.stunning_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.DIVINE.toString()));
    public static final Weapon.Entry unique_spear_sw = ArsenalWeapons.spear("unique_spear_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 8.0f).translatedName("Mounting Vengeance").spell(ArsenalSpells.leeching_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_dagger_1 = ArsenalWeapons.dagger("unique_dagger_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE})), 5.5f).translatedName("Frost Fang").spell(ArsenalSpells.slowing_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FROSTY.toString()));
    public static final Weapon.Entry unique_dagger_2 = ArsenalWeapons.dagger("unique_dagger_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 5.5f).translatedName("Demonic Shiv").spell(ArsenalSpells.leeching_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.EVIL.toString()));
    public static final Weapon.Entry unique_dagger_sw = ArsenalWeapons.dagger("unique_dagger_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 5.5f).translatedName("Crux of the Apocalypse").spell(ArsenalSpells.sundering_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_sickle_1 = ArsenalWeapons.sickle("unique_sickle_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 6.8f).translatedName("Toxic Sickle").spell(ArsenalSpells.poison_cloud_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.GENERIC.toString()));
    public static final Weapon.Entry unique_sickle_2 = ArsenalWeapons.sickle("unique_sickle_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.MAGMA_BLOCK})), 6.8f).translatedName("Infernal Harvester").spell(ArsenalSpells.exploding_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FIERY.toString()));
    public static final Weapon.Entry unique_sickle_sw = ArsenalWeapons.sickle("unique_sickle_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 6.8f).translatedName("Thalassian Sickle").spell(ArsenalSpells.swirling_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_longsword_sw = ArsenalWeapons.sword("unique_longsword_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 8.0f).translatedName("Dragonscale-Encrusted Longblade").spell(ArsenalSpells.sundering_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_double_axe_1 = ArsenalWeapons.axe("unique_double_axe_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 11.0f).translatedName("Dual-blade Butcher").spell(ArsenalSpells.leeching_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.EVIL.toString()));
    public static final Weapon.Entry unique_double_axe_2 = ArsenalWeapons.axe("unique_double_axe_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK})), 11.0f).translatedName("Arcanite Reaper").spell(ArsenalSpells.wither_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.EVIL.toString()));
    public static final Weapon.Entry unique_double_axe_sw = ArsenalWeapons.axe("unique_double_axe_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 11.0f).translatedName("Sunreaver War Axe").spell(ArsenalSpells.rampaging_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_glaive_1 = ArsenalWeapons.glaive("unique_glaive_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 9.3f).translatedName("Hellreaver").spell(ArsenalSpells.flame_cloud_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FIERY.toString()));
    public static final Weapon.Entry unique_glaive_2 = ArsenalWeapons.glaive("unique_glaive_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK})), 9.3f).translatedName("Crystalforge Glaive").spell(ArsenalSpells.shockwave_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.CRYSTAL.toString()));
    public static final Weapon.Entry unique_glaive_sw = ArsenalWeapons.glaive("unique_glaive_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 9.3f).translatedName("Shivering Felspine").spell(ArsenalSpells.swirling_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_hammer_1 = ArsenalWeapons.hammer("unique_hammer_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_BLOCK})), 16.0f).translatedName("Hammer of Destiny").spell(ArsenalSpells.shockwave_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.CRYSTAL.toString()));
    public static final Weapon.Entry unique_hammer_2 = ArsenalWeapons.hammer("unique_hammer_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 16.0f).translatedName("Blackhand").spell(ArsenalSpells.exploding_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.FIERY.toString()));
    public static final Weapon.Entry unique_hammer_sw = ArsenalWeapons.hammer("unique_hammer_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 16.0f).translatedName("Hammer of Sanctification").spell(ArsenalSpells.radiance_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));
    public static final Weapon.Entry unique_mace_1 = ArsenalWeapons.mace("unique_mace_1", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP})), 11.0f).translatedName("Bonecracker").spell(ArsenalSpells.sundering_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.EVIL.toString()));
    public static final Weapon.Entry unique_mace_2 = ArsenalWeapons.mace("unique_mace_2", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK})), 11.0f).translatedName("Stormherald").spell(ArsenalSpells.stunning_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.GENERIC.toString()));
    public static final Weapon.Entry unique_mace_sw = ArsenalWeapons.mace("unique_mace_sw", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK})), 11.0f).translatedName("Archon's Scepter").spell(ArsenalSpells.guarding_strike_melee.id()).loot(Equipment.LootProperties.of((int)5, (String)Loot.Theme.ELVEN.toString()));

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType weaponType) {
        Weapon.Entry entry = new Weapon.Entry("arsenal", name, material, factory, defaults, weaponType);
        entry.castSpell();
        entry.loot(Equipment.LootProperties.of((int)5));
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry claymore(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -3.0f), Equipment.WeaponType.CLAYMORE);
        entry.weaponAttributesPreset = "claymore";
        return entry;
    }

    private static Weapon.Entry hammer(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -3.2f), Equipment.WeaponType.HAMMER);
        entry.weaponAttributesPreset = "hammer";
        return entry;
    }

    private static Weapon.Entry damage_staff(String name, Weapon.CustomMaterial material) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, StaffItem::new, new WeaponConfig(4.0f, -3.0f), Equipment.WeaponType.DAMAGE_STAFF);
        entry.weaponAttributesPreset = "staff";
        return entry;
    }

    private static Weapon.Entry healing_staff(String name, Weapon.CustomMaterial material) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, StaffItem::new, new WeaponConfig(4.0f, -3.0f), Equipment.WeaponType.HEALING_STAFF);
        entry.weaponAttributesPreset = "staff";
        return entry;
    }

    private static Weapon.Entry spear(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -2.6f), Equipment.WeaponType.SPEAR);
        entry.weaponAttributesPreset = "spear";
        return entry;
    }

    private static Weapon.Entry mace(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellWeaponItem::new, new WeaponConfig(damage, -2.8f), Equipment.WeaponType.MACE);
        entry.weaponAttributesPreset = "mace";
        return entry;
    }

    private static Weapon.Entry glaive(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.6f), Equipment.WeaponType.GLAIVE);
        entry.weaponAttributesPreset = "glaive";
        return entry;
    }

    private static Weapon.Entry axe(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.8f), Equipment.WeaponType.DOUBLE_AXE);
        entry.weaponAttributesPreset = "double_axe";
        return entry;
    }

    private static Weapon.Entry dagger(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -1.6f), Equipment.WeaponType.DAGGER);
        entry.weaponAttributesPreset = "dagger";
        return entry;
    }

    private static Weapon.Entry sickle(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.0f), Equipment.WeaponType.SICKLE);
        entry.weaponAttributesPreset = "sickle";
        return entry;
    }

    private static Weapon.Entry sword(String name, Weapon.CustomMaterial material, float damage) {
        Weapon.Entry entry = ArsenalWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.4f), Equipment.WeaponType.SWORD);
        entry.weaponAttributesPreset = "sword";
        return entry;
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Weapon.register(configs, entries, Group.KEY);
    }

    static {
        entries.forEach(entry -> {
            entry.rarity = Rarity.RARE;
        });
    }
}

