/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.arsenal.item.Group;
import net.arsenal.item.Loot;
import net.arsenal.spell.ArsenalSounds;
import net.arsenal.spell.ArsenalSpells;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ShieldConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class ArsenalShields {
    public static final ArrayList<Entry> entries = new ArrayList();
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final int durability_t0 = 168;
    private static final int durability_t1 = 336;
    private static final int durability_t2 = 672;
    private static final int durability_t3 = 1344;
    private static final int durability_t4 = 4032;
    public static Entry unique_shield_1 = ArsenalShields.shield("unique_shield_1", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADD_VALUE)), 4032).translatedName("Bulwark of Azzinoth").spell(ArsenalSpells.spiked_shield.id()).loot(5, Loot.Theme.EVIL.toString());
    public static Entry unique_shield_2 = ArsenalShields.shield("unique_shield_2", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_BLOCK}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADD_VALUE)), 4032).translatedName("Bastion of Light").spell(ArsenalSpells.guarding_shield.id()).loot(5, Loot.Theme.GENERIC.toString());
    public static Entry unique_shield_sw = ArsenalShields.shield("unique_shield_sw", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 2.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADD_VALUE)), 4032).translatedName("Sword Breaker's Bulwark").spell(ArsenalSpells.unyielding_shield.id()).loot(5, Loot.Theme.ELVEN.toString());

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<Ingredient> repair, List<AttributeModifier> attributes, int durability) {
        Entry entry = new Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)name), repair, attributes, durability);
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldConfig> configs) {
        int netheriteTier = Tiers.unsafe((String)"netherite");
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : entries) {
            ShieldConfig config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldConfig();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<Tuple> shieldAttributes = new ArrayList<Tuple>();
            for (ItemAttributeModifiers.Entry modifier : Weapon.attributesFrom((List)config.attributes).modifiers()) {
                shieldAttributes.add(new Tuple((Object)modifier.attribute(), (Object)modifier.modifier()));
            }
            Item.Properties settings = new Item.Properties().durability(config.durability);
            int tier = Tiers.unsafe((ResourceLocation)entry.id());
            if (tier >= netheriteTier) {
                settings.fireResistant();
            }
            if (entry.rarity != Rarity.COMMON) {
                settings.rarity(entry.rarity);
            }
            if (entry.spells != null) {
                settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForShield(entry.spells));
            }
            CustomShieldItem shield = new CustomShieldItem(ArsenalSounds.shield_equip.entry(), entry.repair, shieldAttributes, settings);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Item shield : shields) {
                content.accept((ItemLike)shield);
            }
        });
    }

    static {
        for (Entry entry : entries) {
            entry.rarity = Rarity.RARE;
        }
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final Supplier<Ingredient> repair;
        private final List<AttributeModifier> attributes;
        private final int durability;
        private String translatedName = "";
        public Rarity rarity = Rarity.COMMON;
        public List<ResourceLocation> spells = null;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;

        public Entry(ResourceLocation id, Supplier<Ingredient> repair, List<AttributeModifier> attributes, int durability) {
            this.id = id;
            this.repair = repair;
            this.attributes = attributes;
            this.durability = durability;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Supplier<Ingredient> repair() {
            return this.repair;
        }

        public List<AttributeModifier> attributes() {
            return this.attributes;
        }

        public int durability() {
            return this.durability;
        }

        public Entry translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public String translationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)this.id());
        }

        public Entry spell(ResourceLocation spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public Entry loot(int tier, String theme) {
            this.lootProperties = Equipment.LootProperties.of((int)tier, (String)theme);
            return this;
        }
    }
}

