/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.arsenal.datagen.WeaponAttributeGenerator;
import net.arsenal.item.ArsenalBows;
import net.arsenal.item.ArsenalItemTags;
import net.arsenal.item.ArsenalShields;
import net.arsenal.item.ArsenalWeapons;
import net.arsenal.item.Group;
import net.arsenal.spell.ArsenalEffects;
import net.arsenal.spell.ArsenalSounds;
import net.arsenal.spell.ArsenalSpells;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;

public class ArsenalDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(SpellTagGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(WeaponGen::new);
    }

    public static class WeaponGen
    extends WeaponAttributeGenerator {
        public WeaponGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateWeaponAttributes(WeaponAttributeGenerator.Builder builder) {
            ArsenalWeapons.entries.forEach(entry -> {
                if (entry.weaponAttributesPreset != null && !entry.weaponAttributesPreset.isEmpty()) {
                    builder.entries.add(new WeaponAttributeGenerator.Entry(entry.id(), entry.weaponAttributesPreset));
                }
            });
            ArsenalBows.entries.forEach(entry -> {
                if (entry.weaponAttributesPreset != null && !entry.weaponAttributesPreset.isEmpty()) {
                    builder.entries.add(new WeaponAttributeGenerator.Entry(entry.id(), entry.weaponAttributesPreset));
                }
            });
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("arsenal", ArsenalSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().getPath(), (int)entry.variants())).toList()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArsenalSpells.Entry entry : ArsenalSpells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(BlockModelGenerators blockStateModelGenerator) {
        }

        public void generateItemModels(ItemModelGenerators itemModelGenerator) {
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(HolderLookup.Provider wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add(Group.translationKey, "Arsenal");
            ArsenalWeapons.entries.forEach(entry -> translationBuilder.add(entry.item().getDescriptionId(), entry.translatedName()));
            ArsenalBows.entries.forEach(entry -> translationBuilder.add(entry.item().getDescriptionId(), entry.translatedName()));
            ArsenalShields.entries.forEach(entry -> translationBuilder.add(entry.translationKey(), entry.translatedName()));
            ArsenalSpells.all.forEach(entry -> {
                ResourceLocation id = entry.id();
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".name", entry.title());
                translationBuilder.add("spell." + id.getNamespace() + "." + id.getPath() + ".description", entry.description());
            });
            ArsenalEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.getDescriptionId(), entry.title);
                translationBuilder.add(entry.effect.getDescriptionId() + ".description", entry.description);
            });
        }
    }

    public static class SpellTagGenerator
    extends FabricTagProvider<Spell> {
        public SpellTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, SpellRegistry.KEY, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            ArsenalSpells.all.forEach(entry -> {
                for (ArsenalSpells.Category category : entry.categories()) {
                    TagKey tagKey = TagKey.create((ResourceKey)SpellRegistry.KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)category.toString().toLowerCase()));
                    FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                    tag.addOptional(entry.id());
                }
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            FabricTagProvider.FabricTagBuilder all = this.getOrCreateTagBuilder(ArsenalItemTags.ALL);
            ArsenalWeapons.entries.forEach(entry -> all.addOptional(entry.id()));
            this.generateWeaponTags(ArsenalWeapons.entries);
            List<RPGSeriesDataGen.BowEntry> bowEntries = ArsenalBows.entries.stream().map(entry -> new RPGSeriesDataGen.BowEntry(entry.id(), entry.weaponType, entry.lootProperties)).toList();
            this.generateBowTags(bowEntries);
            List<RPGSeriesDataGen.ShieldEntry> shieldEntries = ArsenalShields.entries.stream().map(entry -> new RPGSeriesDataGen.ShieldEntry(entry.id(), entry.lootProperties)).toList();
            this.generateShieldTags(shieldEntries);
        }
    }
}

