package net.dark.spv_addon.Additions.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class SanityLightStore {
    private static final Set<class_2338> REGISTERED_LIGHT_BLOCKS = new HashSet<>();
    private static final int LIGHT_RADIUS = 15;
    private static final int RADIUS_SQ = LIGHT_RADIUS * LIGHT_RADIUS;

    public static void addLight(class_2338 pos) {
        REGISTERED_LIGHT_BLOCKS.add(pos.method_10062());
    }

    public static void removeLight(class_2338 pos) {
        REGISTERED_LIGHT_BLOCKS.remove(pos);
    }

    public static Set<class_2338> getLightBlocks() {
        return Collections.unmodifiableSet(REGISTERED_LIGHT_BLOCKS);
    }

    public static boolean isNearLight(class_2338 playerPos, int radius) {
        return REGISTERED_LIGHT_BLOCKS.stream()
                .anyMatch(lightPos -> lightPos.method_19771(playerPos, radius));
    }

    public static boolean isPlayerInLightRange(class_1937 world, class_1657 player) {
        class_2338 playerPos = player.method_24515();
        return REGISTERED_LIGHT_BLOCKS.stream()
                .anyMatch(lightSource -> lightSource.method_10262(playerPos) < RADIUS_SQ);
    }
}

/* (pour blocs personnalisés si besoin)
@Override
public void onPlaced(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
    if (!world.isClient) {
        SanityLightStore.addLight(pos);
    }
}

@Override
public void onBroken(WorldAccess world, BlockPos pos, BlockState state) {
    if (!world.isClient()) {
        SanityLightStore.removeLight(pos);
    }
    super.onBroken(world, pos, state);
}
 */