package net.dark.spv_addon.Additions.thirst;

import net.dark.spv_addon.cca.InitializeComponents;
import net.dark.spv_addon.cca.ThirstComponent;
import net.dark.spv_addon.init.CustomDamageSources;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;

public class ThirstManager {
    private static final int INTERVAL_TICKS = 20 * 10;
    public static boolean enabled = true;
    private static int tickCounter = 0;

    public static void register() {
        ServerTickEvents.START_SERVER_TICK.register(ThirstManager::onServerTick);
    }

    private static void onServerTick(MinecraftServer server) {
        if (!enabled || ++tickCounter < INTERVAL_TICKS) return;
        tickCounter = 0;

        for (class_3222 player : server.method_3760().method_14571()) {
            tickPlayer(player);
        }
    }

    private static void tickPlayer(class_3222 player) {
        ThirstComponent comp = InitializeComponents.THIRST.get(player);
        int thirst = comp.getThirst();

        int drain = player.method_5624() ? 2 : player.method_5624() ? 1 : 0;
        thirst = class_3532.method_15340(thirst - drain, 0, 100);
        comp.setThirst(thirst);

        if (thirst <= 25) {
            player.method_6092(new class_1293(class_1294.field_5909, INTERVAL_TICKS, 1, true, false));
            player.method_6092(new class_1293(class_1294.field_5911, INTERVAL_TICKS, 0, true, false));
            if (tickCounter % (20 * 5) == 0) InitializeComponents.SANITY.get(player).decreaseSanity(1);
        }

        if (thirst == 0) {
            class_6880<class_8110> entry = player.method_37908()
                    .method_30349()
                    .method_30530(class_7924.field_42534)
                    .method_40290(CustomDamageSources.THIRST_DAMAGE_ID);

            player.method_6092(new class_1293(class_1294.field_5916, INTERVAL_TICKS, 1, true, false));

            if (tickCounter % (20 * 5) == 0) InitializeComponents.SANITY.get(player).decreaseSanity(5);
            player.method_5643(new class_1282(entry), 4.0f);
        }

    }

    public static void setThirst(class_3222 player, int value) {
        InitializeComponents.THIRST.get(player).setThirst(value);
    }

    public static void increaseThirst(class_1657 player, int value) {
        InitializeComponents.THIRST.get(player).addThirst(value);
    }
}
