package net.dark.spv_addon;

import com.sp.render.pbr.BlockIdMap;
import com.sp.render.pbr.PbrRegistry;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.platform.VeilEventPlatform;
import net.dark.spv_addon.Additions.thirst.ThirstManager;
import net.dark.spv_addon.client.ClientFlashlightRendererAddon;
import net.dark.spv_addon.client.ShaderPuddleHook;
import net.dark.spv_addon.client.gui.BatteryHud;
import net.dark.spv_addon.client.gui.SanityBar;
import net.dark.spv_addon.client.gui.ThirstHud;
import net.dark.spv_addon.commands.WindowCutsceneCommand;
import net.dark.spv_addon.entities.client.renderer.BellWalkerRenderer;
import net.dark.spv_addon.entities.client.renderer.IKEAWalkerRenderer;
import net.dark.spv_addon.entities.client.renderer.KittyRenderer;
import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.entities.custom.IkeaWalkerEntity;
import net.dark.spv_addon.entities.custom.KittyEntity;
import net.dark.spv_addon.entities.custom.StalkerEntity;
import net.dark.spv_addon.init.ModBlocks;
import net.dark.spv_addon.init.ModEntities;
import net.dark.spv_addon.init.grass.GrassRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

@Environment(EnvType.CLIENT)
public class Spv_addonClient implements ClientModInitializer {
    private final ClientFlashlightRendererAddon flashlightRenderer = new ClientFlashlightRendererAddon();
    private GrassRenderer grassRenderer;

    @Override
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) ->
                WindowCutsceneCommand.register(dispatcher));

        ShaderPuddleHook.registerShaderHook();

        ClientTickEvents.END_CLIENT_TICK.register(client ->
                WindowCutsceneCommand.tick());

        BatteryHud.register();
        ThirstHud.register();
        SanityBar.register();
        ThirstManager.register();

        ClientTickEvents.END_CLIENT_TICK.register(client -> flashlightRenderer.tick(client.method_1488()));

        FabricDefaultAttributeRegistry.register(ModEntities.SIX_LEG_ENTITY, BellWalkerEntity.createAttributes());
        EntityRendererRegistry.register(ModEntities.SIX_LEG_ENTITY, BellWalkerRenderer::new);
        FabricDefaultAttributeRegistry.register(ModEntities.KITTY, KittyEntity.createAttributes());
        EntityRendererRegistry.register(ModEntities.KITTY, KittyRenderer::new);
        FabricDefaultAttributeRegistry.register(ModEntities.IKEA_WALKER, IkeaWalkerEntity.createAttributes());
        EntityRendererRegistry.register(ModEntities.IKEA_WALKER, IKEAWalkerRenderer::new);
        FabricDefaultAttributeRegistry.register(ModEntities.STALKER_ENTITY, StalkerEntity.createAttributes());




        ResourceManagerHelper.get(class_3264.field_14188)
                .registerReloadListener(new SimpleSynchronousResourceReloadListener() {
                    @Override
                    public class_2960 getFabricId() {
                        return new class_2960("spv_addon", "after_resources");
                    }

                    @Override
                    public void method_14491(class_3300 manager) {

                        BlockIdMap.registerBlockID(blockIdMap -> {
                            blockIdMap.put(ModBlocks.KITTY_FLOOR, 45);
                            blockIdMap.put(ModBlocks.KITTY_PLUSHIE, 46);
                            blockIdMap.put(ModBlocks.KITTY_PLUSHIE1, 47);
                            blockIdMap.put(ModBlocks.KITTY_PLUSHIE_DEV, 48);
                            blockIdMap.put(ModBlocks.VENT, 49);

                        });


                        PbrRegistry.registerPBR(ModBlocks.KITTY_FLOOR, new PbrRegistry.PbrMaterial(false, 0.5F, 2.0F, 256));
                    }

                });


        VeilEventPlatform.INSTANCE.onVeilRenderTypeStageRender((stage, levelRenderer, bufferSource, poseStack, projectionMatrix, renderTick, partialTicks, camera, frustum) -> {
            class_310 client = class_310.method_1551();
            class_1937 clientWorld = client.field_1687;
            if (clientWorld != null) {

                if (clientWorld.method_27983() != net.dark.spv_addon.init.BackroomsLevels.LEVEL207_WORLD_KEY) {
                    if (this.grassRenderer != null) {
                        this.grassRenderer.close();
                        this.grassRenderer = null;
                    }
                } else if (stage == VeilRenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
                    if (this.grassRenderer == null) {
                        this.grassRenderer = new GrassRenderer();
                    }

                    this.grassRenderer.render();
                }
            }
        });
    }
}
