package net.dark.spv_addon.blocks;

import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2753;
import net.minecraft.class_2754;

public class BedBlock extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2742> PART = class_2754.method_11850("part", class_2742.class);

    private static final class_265 SHAPE = class_259.method_17786(
            class_259.method_1081(0 / 16.0, -3 / 16.0, 0 / 16.0, 2 / 16.0, 6 / 16.0, 2 / 16.0),
            class_259.method_1081(14 / 16.0, -3 / 16.0, 0 / 16.0, 16 / 16.0, 6 / 16.0, 2 / 16.0),
            class_259.method_1081(0 / 16.0, -3 / 16.0, 30 / 16.0, 2 / 16.0, 6 / 16.0, 32 / 16.0),
            class_259.method_1081(14 / 16.0, -3 / 16.0, 30 / 16.0, 16 / 16.0, 6 / 16.0, 32 / 16.0),
            class_259.method_1081(0 / 16.0, 6 / 16.0, 0 / 16.0, 16 / 16.0, 10 / 16.0, 32 / 16.0),
            class_259.method_1081(-0.5 / 16.0, 6.6 / 16.0, -0.9 / 16.0, 16.5 / 16.0, 12.1 / 16.0, 25.2 / 16.0),
            class_259.method_1081(4.3 / 16.0, 7.3 / 16.0, 25.9 / 16.0, 15.7 / 16.0, 11.3 / 16.0, 31.4 / 16.0)
    );

    private static final class_265 SHAPE_EMPTY = class_259.method_1073();

    private static final Map<class_2350, class_265> ROTATED_SHAPES = new EnumMap<>(class_2350.class);

    static {
        ROTATED_SHAPES.put(class_2350.field_11043, SHAPE);
        ROTATED_SHAPES.put(class_2350.field_11035, rotateShape180Foot());
        ROTATED_SHAPES.put(class_2350.field_11039, rotateShape90Foot());
        ROTATED_SHAPES.put(class_2350.field_11034, rotateShape270Foot());
    }

    public BedBlock(class_2251 settings) {
        super(settings);
        method_9590(this.field_10647.method_11664()
                .method_11657(FACING, class_2350.field_11043)
                .method_11657(PART, class_2742.field_12557));
    }

    private static class_265 rotateShape180Foot() {
        class_265[] buffer = new class_265[]{class_259.method_1073()};
        BedBlock.SHAPE.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinX = 1 - maxX;
            double newMaxX = 1 - minX;
            double newMinZ = 1 - maxZ;
            double newMaxZ = 1 - minZ;
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    newMinX, minY, newMinZ, newMaxX, maxY, newMaxZ
            ));
        });
        return buffer[0];
    }

    private static class_265 rotateShape90Foot() {
        class_265[] buffer = new class_265[]{class_259.method_1073()};
        BedBlock.SHAPE.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinZ = 1 - maxX;
            double newMaxZ = 1 - minX;
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    minZ, minY, newMinZ, maxZ, maxY, newMaxZ
            ));
        });
        return buffer[0];
    }

    private static class_265 rotateShape270Foot() {
        class_265[] buffer = new class_265[]{class_259.method_1073()};
        BedBlock.SHAPE.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double newMinX = 1 - maxZ;
            double newMaxX = 1 - minZ;
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    newMinX, minY, minX, newMaxX, maxY, maxX
            ));
        });
        return buffer[0];
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING, PART);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_8042();
        class_2338 headPos = ctx.method_8037().method_10093(facing);
        if (!ctx.method_8045().method_8320(headPos).method_26166(ctx)) return null;
        return method_9564().method_11657(FACING, facing).method_11657(PART, class_2742.field_12557);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable net.minecraft.class_1309 placer, net.minecraft.class_1799 itemStack) {
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, net.minecraft.class_1657 player) {
        class_2742 part = state.method_11654(PART);
        class_2350 facing = state.method_11654(FACING);
        class_2338 otherPos = part == class_2742.field_12557 ? pos.method_10093(facing) : pos.method_10093(facing.method_10153());
        class_2680 otherState = world.method_8320(otherPos);
        if (otherState.method_26204() == this && otherState.method_11654(PART) != part) {
            world.method_8651(otherPos, false, player);
        }
        super.method_9576(world, pos, state, player);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        if (state.method_11654(PART) == class_2742.field_12560) return SHAPE_EMPTY;
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        if (state.method_11654(PART) == class_2742.field_12560) return SHAPE_EMPTY;
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }
}