package net.dark.spv_addon.blocks;

import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3726;

public class ShelfBlock extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12481;

    private static final class_265 SHAPE = class_259.method_1084(
            class_259.method_1081(0.0, 0.0, 0.0, 1.0, 1.0 / 16.0, 1.0),
            class_259.method_1081(0.0, 1.0 / 16.0, 7.0 / 16.0, 1.0, 1.0, 9.0 / 16.0)
    );

    private static final Map<class_2350, class_265> ROTATED_SHAPES = new EnumMap<>(class_2350.class);

    static {
        ROTATED_SHAPES.put(class_2350.field_11043, SHAPE);
        ROTATED_SHAPES.put(class_2350.field_11035, rotateShape180(SHAPE));
        ROTATED_SHAPES.put(class_2350.field_11039, rotateShape90(SHAPE));
        ROTATED_SHAPES.put(class_2350.field_11034, rotateShape270(SHAPE));
    }

    public ShelfBlock(class_2251 settings) {
        super(settings);
        method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    private static class_265 rotateShape180(class_265 shape) {
        class_265[] buffer = {class_259.method_1073()};
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    1 - maxX, minY, 1 - maxZ, 1 - minX, maxY, 1 - minZ
            ));
        });
        return buffer[0];
    }

    private static class_265 rotateShape90(class_265 shape) {
        class_265[] buffer = {class_259.method_1073()};
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    minZ, minY, 1 - maxX, maxZ, maxY, 1 - minX
            ));
        });
        return buffer[0];
    }

    private static class_265 rotateShape270(class_265 shape) {
        class_265[] buffer = {class_259.method_1073()};
        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                    1 - maxZ, minY, minX, 1 - minZ, maxY, maxX
            ));
        });
        return buffer[0];
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8042());
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, net.minecraft.class_2338 pos, class_3726 context) {
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, net.minecraft.class_2338 pos, class_3726 context) {
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }
}