package net.dark.spv_addon.blocks;

import net.dark.spv_addon.blocks.entities.TapeRecorderBlockEntity;
import net.dark.spv_addon.items.custom.TapeItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import java.util.EnumMap;
import java.util.Map;

public class TapeRecorderBlock extends class_2248 implements class_2343 {
    public static final class_2746 PLAYING = class_2746.method_11825("playing");
    public static final class_2753 FACING = class_2741.field_12481;

    // Construction de la forme de collision à partir du modèle Blockbench
    private static final class_265 SHAPE = class_259.method_17786(
            class_259.method_1081(3 / 16.0, -0.2 / 16.0, 2.8 / 16.0, 4 / 16.0, 2.8 / 16.0, 15 / 16.0),
            class_259.method_1081(12 / 16.0, -0.2 / 16.0, 2.8 / 16.0, 13 / 16.0, 2.8 / 16.0, 15 / 16.0),
            class_259.method_1081(4 / 16.0, -0.2 / 16.0, 2.9 / 16.0, 12 / 16.0, 0.8 / 16.0, 15 / 16.0),
            class_259.method_1081(4 / 16.0, 0.8 / 16.0, 10.9 / 16.0, 12 / 16.0, 2.9 / 16.0, 15 / 16.0),
            class_259.method_1081(4 / 16.0, 0.8 / 16.0, 2.8 / 16.0, 12 / 16.0, 2.9 / 16.0, 5 / 16.0),
            class_259.method_1081(3 / 16.0, -0.2 / 16.0, 2 / 16.0, 13 / 16.0, 2 / 16.0, 3 / 16.0),
            class_259.method_1081(3 / 16.0, 1.2 / 16.0, 1.8 / 16.0, 13 / 16.0, 2.4 / 16.0, 2.8 / 16.0),
            class_259.method_1081(11 / 16.0, 1 / 16.0, 2.1 / 16.0, 12 / 16.0, 3 / 16.0, 3.9 / 16.0),
            class_259.method_1081(9 / 16.0, 1 / 16.0, 2.1 / 16.0, 10 / 16.0, 3 / 16.0, 3.9 / 16.0),
            class_259.method_1081(6 / 16.0, 1 / 16.0, 2.1 / 16.0, 7 / 16.0, 3 / 16.0, 3.9 / 16.0),
            class_259.method_1081(4 / 16.0, 1 / 16.0, 2.1 / 16.0, 5 / 16.0, 3 / 16.0, 3.9 / 16.0),
            class_259.method_1081(3.5 / 16.0, 2.6 / 16.0, 5 / 16.0, 12.5 / 16.0, 3.1 / 16.0, 11.4 / 16.0),
            class_259.method_1081(4.05 / 16.0, -0.1 / 16.0, 5.25 / 16.0, 11.95 / 16.0, 0.7 / 16.0, 10.75 / 16.0)
    );

    // Gestion de la rotation comme CrossBlock
    private static final Map<class_2350, class_265> ROTATED_SHAPES = new EnumMap<>(class_2350.class);

    static {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            ROTATED_SHAPES.put(dir, rotateShape(SHAPE, dir));
        }
    }

    public TapeRecorderBlock(class_2251 settings) {
        super(settings);
        method_9590(this.field_10647.method_11664()
                .method_11657(PLAYING, false)
                .method_11657(FACING, class_2350.field_11043));
    }

    private static class_265 rotateShape(class_265 shape, class_2350 dir) {

        if (dir == class_2350.field_11043) return shape;

        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (dir == class_2350.field_11035) ? 2 : (dir == class_2350.field_11039 ? 1 : 3);

        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                // 90 deg Y rotation: (x, z) -> (1-z, x)
                buffer[1] = class_259.method_1084(buffer[1], class_259.method_1081(
                        1 - maxZ, minY, minX, 1 - minZ, maxY, maxX
                ));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(PLAYING, FACING);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564()
                .method_11657(FACING, ctx.method_8042().method_10153())
                .method_11657(PLAYING, false);
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TapeRecorderBlockEntity(pos, state);
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        return ROTATED_SHAPES.get(state.method_11654(FACING));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos,
                              class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof TapeRecorderBlockEntity recorder)) return class_1269.field_5811;

        class_1799 held = player.method_5998(hand);
        if (recorder.hasTape()) {
            player.method_7270(recorder.removeTape());
            world.method_8501(pos, state.method_11657(PLAYING, false));
            return class_1269.field_5812;
        }

        if (held.method_7909() instanceof TapeItem tape) {
            class_1799 inserted = held.method_7971(1);
            recorder.insertTape(inserted);
            class_3414 sound = tape.getSound();
            world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8501(pos, state.method_11657(PLAYING, true));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}