package net.dark.spv_addon.blocks;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class VentBlock extends class_2248 {
    public static final class_2746 OPEN = class_2746.method_11825("open");
    public static final class_2753 FACING = class_2741.field_12481;

    private static final class_265 SHAPE_CLOSED = class_259.method_17786(
            class_259.method_1081(15 / 16.0, 1 / 16.0, 15 / 16.0, 16 / 16.0, 15 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 0 / 16.0, 15 / 16.0, 16 / 16.0, 1 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 15 / 16.0, 15 / 16.0, 16 / 16.0, 16 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 1 / 16.0, 15 / 16.0, 1 / 16.0, 15 / 16.0, 16 / 16.0),
            class_259.method_1081(1 / 16.0, 1 / 16.0, 15.25 / 16.0, 15 / 16.0, 15 / 16.0, 15.75 / 16.0)
    );
    private static final class_265 SHAPE_OPEN = class_259.method_17786(
            class_259.method_1081(15 / 16.0, 1 / 16.0, 15 / 16.0, 16 / 16.0, 15 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 0 / 16.0, 15 / 16.0, 16 / 16.0, 1 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 15 / 16.0, 15 / 16.0, 16 / 16.0, 16 / 16.0, 16 / 16.0),
            class_259.method_1081(0 / 16.0, 1 / 16.0, 15 / 16.0, 1 / 16.0, 15 / 16.0, 16 / 16.0)
    );

    private static final Map<class_2350, class_265> ROTATED_CLOSED = new EnumMap<>(class_2350.class);
    private static final Map<class_2350, class_265> ROTATED_OPEN = new EnumMap<>(class_2350.class);

    static {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            ROTATED_CLOSED.put(dir, rotateShape(SHAPE_CLOSED, dir));
            ROTATED_OPEN.put(dir, rotateShape(SHAPE_OPEN, dir));
        }
    }

    public VentBlock(class_2251 settings) {
        super(settings);
        method_9590(this.field_10647.method_11664()
                .method_11657(OPEN, false)
                .method_11657(FACING, class_2350.field_11035));
    }

    private static class_265 rotateShape(class_265 shape, class_2350 dir) {
        switch (dir) {
            case field_11043:
                return shape;
            case field_11035: {
                class_265[] buffer = new class_265[]{class_259.method_1073()};
                shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                            1 - maxX, minY, 1 - maxZ, 1 - minX, maxY, 1 - minZ
                    ));
                });
                return buffer[0];
            }
            case field_11039: {
                class_265[] buffer = new class_265[]{class_259.method_1073()};
                shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                            minZ, minY, 1 - maxX, maxZ, maxY, 1 - minX
                    ));
                });
                return buffer[0];
            }
            case field_11034: {
                class_265[] buffer = new class_265[]{class_259.method_1073()};
                shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[0] = class_259.method_1084(buffer[0], class_259.method_1081(
                            1 - maxZ, minY, minX, 1 - minZ, maxY, maxX
                    ));
                });
                return buffer[0];
            }
            default:
                return shape;
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(OPEN, FACING);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564()
                .method_11657(FACING, ctx.method_8042().method_10153())
                .method_11657(OPEN, false);
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        return state.method_11654(OPEN) ? ROTATED_OPEN.get(state.method_11654(FACING)) : ROTATED_CLOSED.get(state.method_11654(FACING));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, net.minecraft.class_3726 context) {
        return state.method_11654(OPEN) ? ROTATED_OPEN.get(state.method_11654(FACING)) : ROTATED_CLOSED.get(state.method_11654(FACING));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos,
                              class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            boolean open = !state.method_11654(OPEN);
            world.method_8501(pos, state.method_11657(OPEN, open));
            world.method_8396(null, pos, open ? class_3417.field_15082 : class_3417.field_15131, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.field_5812;
    }
}