package net.dark.spv_addon.blocks.entities;

import com.sp.block.custom.FluorescentLightBlock;
import com.sp.init.BackroomsLevels;
import com.sp.world.levels.BackroomsLevel;
import com.sp.world.levels.custom.Level0BackroomsLevel;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.PointLight;
import net.dark.spv_addon.init.ModBlockEntities;
import net.dark.spv_addon.init.ModBlocks;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public class KittyLightBlockEntity extends class_2586 {
    public final int randInt;
    public class_2680 currentState;
    public class_5819 random = class_5819.method_43047();
    public java.util.Random random1 = new java.util.Random();
    public boolean playingSound = false;
    public PointLight pointLight;
    public boolean prevOn;
    public int ticks = 0;

    public KittyLightBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.KITTY_LIGHT_BLOCK_ENTITY, pos, state);
        this.currentState = state;
        this.randInt = this.random.method_39332(1, 5);
    }

    public void method_11012() {
        super.method_11012();
        if (this.field_11863 != null) {
            if (this.field_11863.field_9236) {
                this.setPlayingSound(false);
                if (this.pointLight != null) {
                    VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer().removeLight(this.pointLight);
                    this.pointLight = null;
                }
            }
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8320(pos).method_26204() == ModBlocks.KITTY_LIGHT) {
            ++this.ticks;
            this.currentState = state;
            if (!world.field_9236) {
                if (world.method_27983() == net.dark.spv_addon.init.BackroomsLevels.LEVEL_KITTY_WORLD_KEY && world.method_8320(pos.method_10074()) != class_2246.field_10124.method_9564()) {
                    world.method_8544(pos);
                    world.method_8500(pos);
                    world.method_8501(pos, ModBlocks.KITTY_ROOF.method_9564());
                    return;
                }

                class_2680 northState = world.method_8320(pos.method_10095());
                class_2680 westState = world.method_8320(pos.method_10067());
                int northOWest = 0;
                if (northState.method_26204() == ModBlocks.KITTY_LIGHT) {
                    northOWest = 1;
                } else if (westState.method_26204() == ModBlocks.KITTY_LIGHT) {
                    northOWest = 2;
                }

                if (northOWest != 0) {
                    if (northOWest == 1) {
                        world.method_8501(pos, northState.method_11657(FluorescentLightBlock.COPY, true));
                    } else {
                        world.method_8501(pos, westState.method_11657(FluorescentLightBlock.COPY, true));
                    }
                } else {
                    if (state.method_11654(FluorescentLightBlock.COPY)) {
                        world.method_8501(pos, ModBlocks.KITTY_LIGHT.method_9564().method_11657(FluorescentLightBlock.COPY, false));
                    }

                    BackroomsLevel var8 = BackroomsLevels.getLevel(this.method_10997());
                    if (!(var8 instanceof Level0BackroomsLevel level)) {
                        return;
                    }

                    if (level.getLightState() == Level0BackroomsLevel.LightState.BLACKOUT) {
                        world.method_8501(pos, world.method_8320(pos).method_11657(FluorescentLightBlock.BLACKOUT, true));
                    }

                    if (level.getLightState() != Level0BackroomsLevel.LightState.ON && state.method_11654(FluorescentLightBlock.ON)) {
                        world.method_8501(pos, world.method_8320(pos).method_11657(FluorescentLightBlock.ON, false));
                    }

                    if (level.getLightState() == Level0BackroomsLevel.LightState.FLICKER && !(Boolean) state.method_11654(FluorescentLightBlock.BLACKOUT)) {
                        if (this.ticks % this.randInt == 0) {
                            boolean i = this.random.method_43056();
                            if (i) {
                                world.method_8501(pos, world.method_8320(pos).method_11657(FluorescentLightBlock.ON, true));
                            } else {
                                world.method_8501(pos, world.method_8320(pos).method_11657(FluorescentLightBlock.ON, false));
                            }
                        }
                    } else if (!(Boolean) state.method_11654(FluorescentLightBlock.ON) && level.getLightState() == Level0BackroomsLevel.LightState.ON) {
                        world.method_8501(pos, world.method_8320(pos).method_11657(FluorescentLightBlock.ON, true));
                    }
                }
            }

            if (this.ticks > 100) {
                this.ticks = 1;
            }

            this.prevOn = world.method_8320(pos).method_11654(FluorescentLightBlock.ON);
        }
    }

    public boolean isPlayingSound() {
        return this.playingSound;
    }

    public void setPlayingSound(boolean playingSound) {
        this.playingSound = playingSound;
    }

    public class_2680 getCurrentState() {
        return this.currentState;
    }
}
