package net.dark.spv_addon.cca;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_2487;

public class RunTimerComponent implements AutoSyncedComponent {
    private int ticksSpentInBackrooms = 0;
    private int noclipThreshold = 18000;
    private boolean active = false;

    @Override
    public void readFromNbt(class_2487 tag) {
        ticksSpentInBackrooms = tag.method_10550("TicksSpentInBackrooms");
        active = tag.method_10577("Active");
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10569("TicksSpentInBackrooms", ticksSpentInBackrooms);
        tag.method_10556("Active", active);
    }

    public boolean isActive() {
        return active;
    }

    public void tick() {
        if (!active) return;
        ticksSpentInBackrooms++;
    }

    public boolean shouldNoclip() {
        return active && ticksSpentInBackrooms >= noclipThreshold;
    }

    public void reset() {
        ticksSpentInBackrooms = 0;
        active = false;
    }

    public void activate(int minTicks, int maxTicks) {
        noclipThreshold = minTicks + (int) (Math.random() * (maxTicks - minTicks));
        active = true;
    }
}
