package net.dark.spv_addon.cca;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class ThirstComponent implements ComponentV3, AutoSyncedComponent {
    public static final ComponentKey<ThirstComponent> KEY2 =
            ComponentRegistry.getOrCreate(new class_2960("spv_addon", "thirst"), ThirstComponent.class);


    private static final int MAX_THIRST = 100;
    private final class_1657 player;
    private int thirst = MAX_THIRST;

    public ThirstComponent(class_1657 player) {
        this.player = player;
    }

    public int getThirst() {
        return thirst;
    }

    public void setThirst(int thirst) {
        this.thirst = Math.max(0, Math.min(MAX_THIRST, thirst));
        InitializeComponents.THIRST.sync(player);
    }

    public void addThirst(int amount) {
        setThirst(thirst + amount);
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        thirst = tag.method_10550("thirst");
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10569("thirst", thirst);
    }
}
