package net.dark.spv_addon.client;

import com.sp.cca_stuff.InitializeComponents;
import com.sp.cca_stuff.PlayerComponent;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import net.dark.spv_addon.Additions.battery.BatteryManager;
import net.dark.spv_addon.init.CustomDamageSources;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.joml.Quaternionf;

import java.util.*;

public class ClientFlashlightRendererAddon {

    private final class_310 client = class_310.method_1551();
    private final Map<UUID, List<AreaLight>> lightMap = new HashMap<>();

    public void tick(float tickDelta) {
        if (client.field_1687 == null) return;

        for (class_742 player : client.field_1687.method_18456()) {
            if (player.method_7325()) {
                forceOff(player);
                continue;
            }

            UUID uuid = player.method_5667();
            PlayerComponent comp = InitializeComponents.PLAYER.get(player);
            boolean isOn = comp.isFlashLightOn();
            int sanity = net.dark.spv_addon.cca.InitializeComponents.SANITY.get(player).getSanityLevel();
            int battery = BatteryManager.getBattery(uuid);
            if (battery <= 0) {
                if (isOn) comp.setFlashLightOn(false);
                forceOff(player);
                continue;
            }

            if (sanity <= 20) {
                if (client.field_1687.method_8409().method_43057() > 0.135f) {
                    if (!comp.isFlashLightOn()) comp.setFlashLightOn(true);
                    updateLight(player, tickDelta);
                } else {
                    for (int i = 0; i < 5; i++) {
                        boolean shouldBeOn = client.field_1687.method_8409().method_43056();

                        comp.setFlashLightOn(shouldBeOn);
                        if (shouldBeOn) {
                            updateLight(player, tickDelta);
                        } else {
                            removeLights(player);
                        }
                    }
                }
                continue;
            }

            if (sanity <= 0) {
                if (!comp.shouldGlitch()) {
                    comp.setShouldGlitch(true);
                    comp.justChanged();
                    if (!comp.shouldInflictGlitchDamage) {
                        class_6880<class_8110> entry = player.method_37908()
                                .method_30349()
                                .method_30530(class_7924.field_42534)
                                .method_40290(CustomDamageSources.DISTORTION_DAMAGE_ID);
                    }
                }
            } else {
                if (comp.shouldGlitch()) {
                    comp.setShouldGlitch(false);
                    comp.justChanged();
                    comp.shouldInflictGlitchDamage = false;
                }
            }

            if (isOn) {
                updateLight(player, tickDelta);
            } else {
                removeLights(player);
            }
        }
    }

    private void updateLight(class_742 player, float tickDelta) {
        UUID uuid = player.method_5667();
        class_243 pos = player.method_5836(tickDelta);
        Quaternionf rot = new Quaternionf()
                .rotateXYZ((float) -Math.toRadians(player.method_5695(tickDelta)),
                        (float) Math.toRadians(player.method_5705(tickDelta)), 0f);

        List<AreaLight> lights = lightMap.computeIfAbsent(uuid, id -> {
            AreaLight l1 = new AreaLight().setBrightness(1f).setDistance(25f)
                    .setSize(0, 0).setPosition(pos.field_1352, pos.field_1351, pos.field_1350).setOrientation(rot);
            AreaLight l2 = new AreaLight().setBrightness(1f).setDistance(25f)
                    .setAngle(0.25f).setSize(0, 0).setPosition(pos.field_1352, pos.field_1351, pos.field_1350).setOrientation(rot);
            return Arrays.asList(l1, l2);
        });

        for (AreaLight light : lights) {
            light.setPosition(pos.field_1352, pos.field_1351, pos.field_1350);
            light.getOrientation().slerp(rot, 0.7f * client.method_1534());
        }
    }

    private void forceOff(class_742 player) {
        PlayerComponent comp = InitializeComponents.PLAYER.get(player);
        if (comp.isFlashLightOn()) {
            comp.setFlashLightOn(false);
        }
        removeLights(player);
    }

    private void removeLights(class_742 player) {
        UUID uuid = player.method_5667();
        List<AreaLight> lights = lightMap.remove(uuid);
        if (lights != null) {
            for (AreaLight light : lights) {
                VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer().removeLight(light);
            }
        }
    }
}
