package net.dark.spv_addon.client;

import com.sp.init.BackroomsLevels;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.platform.VeilEventPlatform;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ShaderPuddleHook {

    private static final class_2960 EVERYTHING_SHADER = new class_2960("spb", "everything");

    public static void registerShaderHook() {
        VeilEventPlatform.INSTANCE.preVeilPostProcessing((name, pipeline, context) -> {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            class_638 world = client.field_1687;

            if (player == null || world == null) return;

            ShaderProgram shaderProgram = context.getShader(EVERYTHING_SHADER);
            if (shaderProgram != null) {
                boolean inLevelWithPuddles = isPuddleWorld(world);
                shaderProgram.setInt("TogglePuddles", inLevelWithPuddles ? 1 : 0);
            }
        });
    }

    private static boolean isPuddleWorld(class_638 world) {
        // Assure que Level 1 et Level 207 activent bien les flaques
        return world.method_27983() == BackroomsLevels.LEVEL1_WORLD_KEY
                || world.method_27983() == net.dark.spv_addon.init.BackroomsLevels.LEVEL207_WORLD_KEY;
    }
}
