package net.dark.spv_addon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sp.cca_stuff.InitializeComponents;
import com.sp.cca_stuff.PlayerComponent;
import net.dark.spv_addon.Additions.battery.BatteryManager;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

import static net.dark.spv_addon.Spv_addon.MOD_ID;

public class BatteryHud implements HudRenderCallback {
    private static final class_2960 BATTERY_1 = new class_2960(MOD_ID, "textures/gui/battery1.png");
    private static final class_2960 BATTERY_2 = new class_2960(MOD_ID, "textures/gui/battery2.png");
    private static final int BAR_W = 44, BAR_H = 44;
    private static final float SCALE = 0.8f;

    public static void register() {
        HudRenderCallback.EVENT.register(new BatteryHud());
    }

    @Override
    public void onHudRender(class_332 dc, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_1657 player = client.field_1724;
        if (player == null) return;

        int level = BatteryManager.getBattery(player.method_5667());
        PlayerComponent comp = InitializeComponents.PLAYER.getNullable(player);

        if (level != 0 && (comp == null || !comp.isFlashLightOn())) return;

        float norm = Math.max(0, Math.min(level, 100)) / 100f;
        int filledHeight = Math.round(norm * BAR_H);

        float alpha = (level <= 15) ? getPulseAlpha() : 1f;

        int sw = client.method_22683().method_4486();
        int x = sw - (int) (BAR_W * SCALE) - 16;
        int y = 16;


        dc.method_51448().method_22903();
        dc.method_51448().method_46416(x, y, 0);
        dc.method_51448().method_22905(SCALE, SCALE, SCALE);

        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1f, 1f, 1f, alpha);

        dc.method_25290(BATTERY_1, 0, 0, 0, 0, BAR_W, BAR_H, 44, 44);

        if (filledHeight > 0) {
            dc.method_25290(BATTERY_2, 0, BAR_H - filledHeight, 0, BAR_H - filledHeight, BAR_W, filledHeight, 44, 44);
        }

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.disableBlend();
        dc.method_51448().method_22909();

        String txt = level + "%";
        int tw = client.field_1772.method_1727(txt);
        int tx = x + (int) (BAR_W * SCALE) / 2 - tw / 2;
        int ty = y + (int) (BAR_H * SCALE) + 2;
        dc.method_51433(client.field_1772, txt, tx, ty, 0xFFFFFF, true);
    }

    private float getPulseAlpha() {
        double t = class_156.method_658() / 600.0;
        double sway = (Math.sin(t) + 1.0) / 2.0;
        return 0.3f + (float) (sway * 0.7f);
    }
}
