package net.dark.spv_addon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dark.spv_addon.init.ModSounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;


@Environment(EnvType.CLIENT)
public class CustomDeathScreen extends class_437 {
    private static final class_2960 BACKGROUND = new class_2960("spv_addon", "textures/gui/death_full.png");
    private static final class_2960 SCANLINES = new class_2960("spv_addon", "textures/gui/scanlines.png");
    private final String playerName;
    private final class_2960 dynamicStaticId = new class_2960("spv_addon", "dynamic_static");
    private int ticksElapsed = 0;
    private int glitchTicks = 0;
    private boolean isGlitching = false;
    private class_1011 staticImage = null;
    private class_1043 staticTexture = null;

    public CustomDeathScreen(String playerName) {
        super(class_2561.method_43473());
        this.playerName = playerName;
        playDeathSound();
    }

    @Override
    public void method_25393() {
        if (!isGlitching) {
            ticksElapsed++;
            if (ticksElapsed >= 200) {
                startGlitch();
            }
        } else {
            glitchTicks++;
            if (glitchTicks >= 16) {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 != null) mc.field_1724.method_7331();
                mc.method_1507(null);
                closeStaticImage();
            }
        }
    }

    private void updateStaticTexture(int w, int h) {
        if (staticImage == null || staticImage.method_4307() != w || staticImage.method_4323() != h) {
            closeStaticImage();
            staticImage = new class_1011(w, h, false);
            staticTexture = new class_1043(staticImage);
        }
        for (int y = 0; y < h; y++) {
            for (int x = 0; x < w; x++) {
                int val = isGlitching ? (int) (Math.random() * 255) : (int) (Math.random() * 192 + 32);
                int color = 0xFF000000 | (val << 16) | (val << 8) | val;
                staticImage.method_4305(x, y, color);
            }
        }
        staticTexture.method_4524();
        class_310.method_1551().method_1531().method_4616(dynamicStaticId, staticTexture);
    }

    private void closeStaticImage() {
        if (staticImage != null) staticImage.close();
        staticImage = null;
        staticTexture = null;
    }

    private void startGlitch() {
        isGlitching = true;
        glitchTicks = 0;
    }

    @Override
    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_310 mc = class_310.method_1551();
        int w = mc.method_22683().method_4486();
        int h = mc.method_22683().method_4502();

        RenderSystem.enableBlend();
        ctx.method_25290(BACKGROUND, 0, 0, 0, 0, w, h, w, h);
        RenderSystem.disableBlend();

        int fontHeight = mc.field_1772.field_2000 + 8; // bigger
        int fontScale = 2;

        String line1 = playerName + " was";
        String line2 = "Never Found";
        int color = 0xFFFFFF;

        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(w / 2f, h / 2f - fontHeight, 0f);
        ctx.method_51448().method_22905(fontScale, fontScale, 1f);
        int x1 = -mc.field_1772.method_1727(line1) / 2;
        int y1 = 0;
        ctx.method_51439(mc.field_1772, class_2561.method_43470(line1), x1, y1, color, false);

        int x2 = -mc.field_1772.method_1727(line2) / 2;
        int y2 = (fontHeight + 2) / fontScale; // spacing
        ctx.method_51439(mc.field_1772, class_2561.method_43470(line2), x2, y2, color, false);
        ctx.method_51448().method_22909();

        float frac = Math.min(ticksElapsed / 200f, 1f);
        float flicker = (float) (Math.sin(ticksElapsed * 0.6 + Math.random()) * 0.15 + 0.85);
        float alpha = isGlitching
                ? (float) (Math.random() * 0.7 + 0.3f) // during glitch, static jumps up
                : frac * flicker;

        updateStaticTexture(w, h);

        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1f, 1f, 1f, alpha);
        ctx.method_25290(dynamicStaticId, 0, 0, 0, 0, w, h, w, h);


        RenderSystem.setShaderColor(1f, 1f, 1f, 0.10f * alpha);
        ctx.method_25290(SCANLINES, 0, 0, 0, 0, w, h, w, h);


        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.disableBlend();
    }

    @Override
    public void method_25419() {
        super.method_25419();
        stopDeathSound();
        closeStaticImage();
    }

    private void playDeathSound() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.method_1483().method_4873(net.minecraft.class_1109.method_4759(class_3414.method_47908(ModSounds.DEATH_SOUND.method_14833())));
        }
    }

    private void stopDeathSound() {
        class_310 mc = class_310.method_1551();
        mc.method_1483().method_4875(ModSounds.DEATH_SOUND.method_14833(), net.minecraft.class_3419.field_15253);

    }
}

