package net.dark.spv_addon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dark.spv_addon.cca.SanityComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(EnvType.CLIENT)
public class SanityBar implements HudRenderCallback {
    private static final class_2960 SANITY_EMPTY = new class_2960("spv_addon", "textures/gui/sanity_0.png");
    private static final class_2960 SANITY_FULL = new class_2960("spv_addon", "textures/gui/sanity_icon.png");
    private static final int ICON_W = 32, ICON_H = 32; // Taille de la texture
    private static final float SCALE = 1.0f; // Pour garder même rendu que les autres
    private static final int X_MARGIN = 16 + (int) (44 * 0.75f) + 12; // Décale à droite de la ThirstHud (qui fait ~33px avec scale)
    private static final int Y_MARGIN = 16; // Même base en bas de l'écran

    public static void register() {
        HudRenderCallback.EVENT.register(new SanityBar());
    }

    @Override
    public void onHudRender(class_332 dc, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_1657 player = client.field_1724;
        if (player == null) return;

        var compOpt = SanityComponent.KEY1.maybeGet(player);
        if (compOpt.isEmpty()) return;
        int sanity = Math.max(0, Math.min(100, compOpt.get().getSanityLevel()));

        float norm = sanity / 100f;
        int fillWidth = Math.round(norm * ICON_W);

        float alpha = (sanity <= 15) ? getPulseAlpha() : 1f;

        int sh = client.method_22683().method_4502();
        int x = X_MARGIN; // Juste à droite de la ThirstHud
        int y = sh - (int) (ICON_H * SCALE) - 16; // Même base que la soif

        dc.method_51448().method_22903();
        dc.method_51448().method_46416(x, y, 0);
        dc.method_51448().method_22905(SCALE, SCALE, SCALE);

        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1f, 1f, 1f, alpha);

        // Fond vide
        dc.method_25290(SANITY_EMPTY, 0, 0, 0, 0, ICON_W, ICON_H, ICON_W, ICON_H);

        // Remplissage horizontal
        if (fillWidth > 0) {
            dc.method_25290(
                    SANITY_FULL,
                    0, 0,
                    0, 0,
                    fillWidth, ICON_H,
                    ICON_W, ICON_H
            );
        }

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.disableBlend();
        dc.method_51448().method_22909();

        // % texte sous la barre
        String txt = sanity + "%";
        int tw = client.field_1772.method_1727(txt);
        dc.method_51433(client.field_1772, txt, x + (int) (ICON_W * SCALE) / 2 - tw / 2, y + (int) (ICON_H * SCALE) + 2, 0xFFFFFF, true);
    }

    private float getPulseAlpha() {
        double t = class_156.method_658() / 600.0;
        double sway = (Math.sin(t) + 1.0) / 2.0;
        return 0.3f + (float) (sway * 0.7f);
    }
}
