package net.dark.spv_addon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dark.spv_addon.cca.InitializeComponents;
import net.dark.spv_addon.cca.ThirstComponent;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ThirstHud implements HudRenderCallback {
    private static final class_2960 THIRST_EMPTY = new class_2960("spv_addon", "textures/gui/thirst_0.png");
    private static final class_2960 THIRST_FULL = new class_2960("spv_addon", "textures/gui/thirst_icon.png");
    // Les textures doivent faire 44x64px (fond et remplissage)
    private static final int ICON_W = 64, ICON_H = 44;
    private static final float SCALE = 0.75f; // Ajuste pour la taille finale affichée
    private static final int X_MARGIN = 70, Y_MARGIN = 40; // Position à caler selon ta GUI

    public static void register() {
        HudRenderCallback.EVENT.register(new ThirstHud());
    }

    @Override
    public void onHudRender(class_332 dc, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_1657 player = client.field_1724;
        if (player == null) return;

        ThirstComponent thirst = InitializeComponents.THIRST.getNullable(player);
        if (thirst == null) return;

        int level = thirst.getThirst();
        float norm = Math.max(0, Math.min(level, 100)) / 100f;
        int filledHeight = Math.round(norm * ICON_H);

        float alpha = (level <= 15) ? getPulseAlpha() : 1f;

        int sw = client.method_22683().method_4486();
        int sh = client.method_22683().method_4502();

        int x = 16; // 16px depuis le bord gauche
        int y = sh - (int) (ICON_H * SCALE) - 16; // 16px depuis le bas

        dc.method_51448().method_22903();
        dc.method_51448().method_46416(x, y, 0);
        dc.method_51448().method_22905(SCALE, SCALE, SCALE);

        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(1f, 1f, 1f, alpha);

        dc.method_25290(THIRST_EMPTY, 0, 0, 0, 0, ICON_W, ICON_H, ICON_W, ICON_H);

        if (filledHeight > 0) {
            dc.method_25290(
                    THIRST_FULL,
                    0, ICON_H - filledHeight,
                    0, ICON_H - filledHeight,
                    ICON_W, filledHeight,
                    ICON_W, ICON_H
            );
        }

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.disableBlend();
        dc.method_51448().method_22909();

        // Texte %
        String txt = level + "%";
        int tw = client.field_1772.method_1727(txt);
        dc.method_51433(client.field_1772, txt, x + (int) (ICON_W * SCALE) / 2 - tw / 2, y + (int) (ICON_H * SCALE) + 2, 0xFFFFFF, true);
    }

    private float getPulseAlpha() {
        double t = class_156.method_658() / 600.0;
        double sway = (Math.sin(t) + 1.0) / 2.0;
        return 0.3f + (float) (sway * 0.7f);
    }
}
