package net.dark.spv_addon.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.dark.spv_addon.Additions.battery.BatteryManager;
import net.dark.spv_addon.Additions.thirst.ThirstManager;
import net.dark.spv_addon.cca.InitializeComponents;
import net.dark.spv_addon.cca.SanityComponent;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SpvCommands {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("spv")
                .then(class_2170.method_9247("battery")
                        .then(class_2170.method_9247("toggle")
                                .executes(ctx -> {
                                    boolean current = BatteryManager.isBatteryEnabled();
                                    BatteryManager.setBatteryEnabled(!current);
                                    ctx.getSource().method_9226(() ->
                                                    class_2561.method_43470("Battery drain is now " + (!current ? "enabled" : "disabled")),
                                            false
                                    );
                                    return 1;
                                }))
                        .then(class_2170.method_9247("set")
                                .then(class_2170.method_9244("value", IntegerArgumentType.integer(0, 100))
                                        .executes(ctx -> {
                                            int value = IntegerArgumentType.getInteger(ctx, "value");
                                            BatteryManager.setBattery(ctx.getSource().method_44023().method_5667(), value);
                                            ctx.getSource().method_9226(() ->
                                                            class_2561.method_43470("Battery set to " + value),
                                                    false
                                            );
                                            return 1;
                                        }))))
                .then(class_2170.method_9247("sanity")
                        .then(class_2170.method_9244("value", IntegerArgumentType.integer(0, 100))
                                .executes(ctx -> {
                                    class_3222 player = ctx.getSource().method_44023();
                                    int value = IntegerArgumentType.getInteger(ctx, "value");
                                    SanityComponent sanity = InitializeComponents.SANITY.get(player);
                                    sanity.setSanityLevel(value);
                                    ctx.getSource().method_9226(() ->
                                            class_2561.method_43470("Sanity set to " + value), false);
                                    return 1;
                                })))
                .then(class_2170.method_9247("thirst")
                        .then(class_2170.method_9247("set")
                                .then(class_2170.method_9244("amount", IntegerArgumentType.integer(0, 100))
                                        .executes(ctx -> {
                                            class_2168 src = ctx.getSource();
                                            class_3222 player = src.method_44023();
                                            int amt = IntegerArgumentType.getInteger(ctx, "amount");
                                            ThirstManager.setThirst(player, amt);
                                            player.method_7353(class_2561.method_30163("§cthirst set to " + amt), false);
                                            return 1;
                                        })))
                        .then(class_2170.method_9247("enabled")
                                .then(class_2170.method_9244("value", BoolArgumentType.bool())
                                        .executes(ctx -> {
                                            boolean on = BoolArgumentType.getBool(ctx, "value");
                                            ThirstManager.enabled = on;
                                            class_2168 src = ctx.getSource();
                                            class_3222 player = src.method_44023();
                                            player.method_7353(class_2561.method_30163("§aThirst system " + (on ? "enabled" : "disabled")), false);
                                            return 1;
                                        })))
                )
        );
    }
}