package net.dark.spv_addon.entities.ai.goals;

import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.init.ModSounds;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_5134;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

/**
 * AggroNearestPlayerGoal: cible le joueur qui parle le plus près et joue un son selon la distance.
 */
public class AggroNearestPlayerGoal extends class_1352 {
    private static final int MIN_SOUND_DELAY = 5;   // délai min (proche)
    private static final int MAX_SOUND_DELAY = 40;  // délai max (loin)
    private final BellWalkerEntity mob;
    private final double maxRange;
    private final double aggroSpeed;
    private double originalSpeed;
    private int soundCooldown;
    private class_1657 lastTarget;

    public AggroNearestPlayerGoal(BellWalkerEntity mob, double maxRange, double aggroSpeed) {
        this.mob = mob;
        this.maxRange = maxRange;
        this.aggroSpeed = aggroSpeed;
        this.method_6265(EnumSet.of(class_4134.field_18408));
    }

    public AggroNearestPlayerGoal(BellWalkerEntity mob, double maxRange) {
        this(mob, maxRange, 0.6);
    }

    @Override
    public boolean method_6264() {
        List<? extends class_1657> candidates = mob.method_37908().method_18456().stream()
                .filter(p -> mob.method_6017() >= 2)
                .filter(p -> p.method_5858(mob) <= maxRange * maxRange)
                .toList();
        if (candidates.isEmpty()) {
            return false;
        }
        // Select nearest
        class_1657 nearest = candidates.stream()
                .min(Comparator.comparingDouble(p -> p.method_5858(mob)))
                .orElse(null);
        mob.method_5980(nearest);
        lastTarget = nearest;
        return nearest != null;
    }

    @Override
    public void method_6269() {
        if (lastTarget == null) return;
        // Boost la vitesse
        class_1324 attr = mob.method_5996(class_5134.field_23719);
        if (attr != null) {
            originalSpeed = attr.method_6201();
            attr.method_6192(aggroSpeed);
        }
        double distSq = lastTarget.method_5858(mob);
        soundCooldown = calculateSoundDelay(distSq);
    }

    @Override
    public void method_6268() {
        class_1309 target = mob.method_5968();
        if (target instanceof class_1657) {
            if (--soundCooldown <= 0) {
                mob.method_5783(ModSounds.BELLWALKER_BELL, 1.0f, 1.0f);
                soundCooldown = calculateSoundDelay(target.method_5858(mob));
            }
        }
    }

    private int calculateSoundDelay(double squaredDistance) {
        double distance = Math.sqrt(squaredDistance);
        double ratio = Math.min(distance / maxRange, 1.0);
        return (int) (MIN_SOUND_DELAY + (MAX_SOUND_DELAY - MIN_SOUND_DELAY) * ratio);
    }

    @Override
    public boolean method_6266() {
        class_1309 target = mob.method_5968();
        return target instanceof class_1657
                && target.method_5805()
                && mob.method_6017() >= 2;
    }

    @Override
    public void method_6270() {
        // Restore speed when finished
        class_1324 attr = mob.method_5996(class_5134.field_23719);
        if (attr != null) {
            attr.method_6192(originalSpeed);
        }
        lastTarget = null;
    }
}
