package net.dark.spv_addon.entities.ai.goals;

import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.init.ModSounds;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_5717;
import java.util.EnumSet;
import java.util.Optional;

public class BellWalkerStalkGoal extends class_1352 implements class_5714 {
    private final BellWalkerEntity mob;
    private final double stalkSpeed;
    private final double wanderSpeed;
    private int lostTargetTicks = 0;
    private class_2338 soundHeardPos = null;
    private int soundHeardTicks = 0;

    public BellWalkerStalkGoal(BellWalkerEntity mob, double stalkSpeed, double wanderSpeed) {
        this.mob = mob;
        this.stalkSpeed = stalkSpeed;
        this.wanderSpeed = wanderSpeed;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        return mob.hasStalkTarget() || mob.method_5942().method_6357() || soundHeardPos != null;
    }

    @Override
    public void method_6268() {
        class_1657 target = mob.getStalkTarget();

        // Si un son a été entendu récemment, s'y rendre
        if (soundHeardPos != null) {
            if (mob.method_5942().method_6357() || mob.field_6012 % 10 == 0) {
                mob.method_5942().method_6337(soundHeardPos.method_10263(), soundHeardPos.method_10264(), soundHeardPos.method_10260(), stalkSpeed);
            }
            soundHeardTicks++;
            if (soundHeardTicks > 40) {
                soundHeardPos = null;
                soundHeardTicks = 0;
            }
            mob.method_5875(false);
            mob.method_5977(false);
            mob.method_5980(null);
            mob.method_5834(false);
            return;
        }

        if (target != null) {
            if (!target.method_5805() || target.method_5739(mob) > 40) {
                lostTargetTicks++;
                if (lostTargetTicks > 40) {
                    mob.clearStalkTarget();
                    lostTargetTicks = 0;
                }
                return;
            } else {
                lostTargetTicks = 0;
            }

            if (mob.method_5942().method_6357() || mob.field_6012 % 10 == 0) {
                mob.method_5942().method_6335(target, stalkSpeed);
            }

            mob.method_5875(false);
            mob.method_5977(false);
            mob.method_5980(null);

            if (mob.field_6012 % 20 == 0) {
                mob.method_5783(ModSounds.BELLWALKER_BELL, 0.7f, 1.2f);
                mob.method_37908().method_8406(class_2398.field_11251,
                        mob.method_23317(), mob.method_23318() + 1.2, mob.method_23321(),
                        0, 0.05, 0);
            }
        } else {
            if (mob.method_5942().method_6357() || mob.field_6012 % 60 == 0) {
                double angle = mob.method_37908().field_9229.method_43058() * 2 * Math.PI;
                double dx = Math.cos(angle) * 6;
                double dz = Math.sin(angle) * 6;
                class_2338 pos = mob.method_24515().method_10069((int) dx, 0, (int) dz);
                mob.method_5942().method_6337(pos.method_10263(), pos.method_10264(), pos.method_10260(), wanderSpeed);
            }
            mob.method_5875(false);
            mob.method_5977(false);
            mob.method_5980(null);
        }
        mob.method_5834(false);
    }

    @Override
    public boolean method_6266() {
        return true;
    }

    @Override
    public class_5716 method_32946() {
        return new class_5716() {
            @Override
            public Optional<class_243> method_32956(class_1937 world) {
                return Optional.empty();
            }

            @Override
            public class_5717<?> method_32955() {
                return null;
            }

            public class_243 getPos(class_3218 world) {
                return mob.method_19538();
            }
        };
    }

    @Override
    public int method_32948() {
        return 64;
    }

    @Override
    public boolean method_32947(class_3218 world, class_5712 event, class_5712.class_7397 emitter, class_243 emitterPos) {
        if (event == class_5712.field_28155 || event == class_5712.field_28725 || event == class_5712.field_28736) {
            if (mob.method_5707(emitterPos) < 64 * 64) {
                soundHeardPos = new class_2338((int) emitterPos.field_1352, (int) emitterPos.field_1351, (int) emitterPos.field_1350);
                soundHeardTicks = 0;
            }
        }
        return true;
    }
}