package net.dark.spv_addon.entities.client.renderer;

import com.sp.entity.ik.model.GeckoLib.GeoModelAccessor;
import com.sp.entity.ik.model.GeckoLib.MowzieGeoBone;
import net.dark.spv_addon.entities.client.model.BellWalkerModel;
import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.DynamicGeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class BellWalkerRenderer extends DynamicGeoEntityRenderer<BellWalkerEntity> {

    public BellWalkerRenderer(class_5617.class_5618 context) {
        super(context, new BellWalkerModel());
    }

    @Override
    public void render(BellWalkerEntity entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);

        entity.getModelPositions(entity, new GeoModelAccessor(this.model));

    }


    @Override
    public void renderRecursively(class_4587 poseStack, BellWalkerEntity animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone == null) return;
        poseStack.method_22903();
        if (bone instanceof MowzieGeoBone mowzieGeoBone && mowzieGeoBone.isForceMatrixTransform() && animatable != null) {
            class_4587.class_4665 last = poseStack.method_23760();
            double d0 = animatable.method_23317();
            double d1 = animatable.method_23318();
            double d2 = animatable.method_23321();
            Matrix4f matrix4f = new Matrix4f();
            matrix4f = matrix4f.translate(0, -0.01f, 0);
            matrix4f = matrix4f.translate((float) -d0, (float) -d1, (float) -d2);
            matrix4f = matrix4f.mul(bone.getWorldSpaceMatrix());
            last.method_23761().mul(matrix4f);
            last.method_23762().mul(bone.getWorldSpaceNormal());

            RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        } else {
            boolean rotOverride = false;
            if (bone instanceof MowzieGeoBone mowzieGeoBone) {
                rotOverride = mowzieGeoBone.rotationOverride != null;
            }

            RenderUtils.translateMatrixToBone(poseStack, bone);
            RenderUtils.translateToPivotPoint(poseStack, bone);

            if (bone instanceof MowzieGeoBone mowzieGeoBone) {
                if (!mowzieGeoBone.inheritRotation && !mowzieGeoBone.inheritTranslation) {
                    poseStack.method_23760().method_23761().identity();
                    poseStack.method_23760().method_23761().mul(this.entityRenderTranslations);
                } else if (!mowzieGeoBone.inheritRotation) {
                    Vector4f t = new Vector4f().mul(poseStack.method_23760().method_23761());
                    poseStack.method_23760().method_23761().identity();
                    poseStack.method_46416(t.x, t.y, t.z);
                } else if (!mowzieGeoBone.inheritTranslation) {
                    MowzieGeoBone.removeMatrixTranslation(poseStack.method_23760().method_23761());
                    poseStack.method_23760().method_23761().mul(this.entityRenderTranslations);
                }
            }

            if (rotOverride) {
                MowzieGeoBone mowzieGeoBone = (MowzieGeoBone) bone;
                poseStack.method_23760().method_23761().mul(mowzieGeoBone.rotationOverride);
                poseStack.method_23760().method_23762().mul(new Matrix3f(mowzieGeoBone.rotationOverride));
            } else {
                RenderUtils.rotateMatrixAroundBone(poseStack, bone);
            }

            RenderUtils.scaleMatrixForBone(poseStack, bone);

            if (bone.isTrackingMatrices()) {
                Matrix4f poseState = new Matrix4f(poseStack.method_23760().method_23761());
                Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);

                bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
                bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, method_23169(this.animatable, 1).method_46409()));
                bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f(localMatrix), this.animatable.method_19538().method_46409()));
            }

            RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        }

        this.textureOverride = getTextureOverrideForBone(bone, this.animatable, partialTick);
        class_2960 texture = this.textureOverride == null ? method_3931(this.animatable) : this.textureOverride;
        class_1921 renderTypeOverride = getRenderTypeOverrideForBone(bone, this.animatable, texture, bufferSource, partialTick);

        if (texture != null && renderTypeOverride == null)
            renderTypeOverride = getRenderType(this.animatable, texture, bufferSource, partialTick);

        if (renderTypeOverride != null)
            buffer = bufferSource.getBuffer(renderTypeOverride);

        renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);

        if (!isReRender)
            applyRenderLayersForBone(poseStack, animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);

        renderChildBones(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);

        poseStack.method_22909();
    }
}
